/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class InferenceIncorporationPhase {
    private static final Logger LOG = Logger.getInstance("#" + InferenceIncorporationPhase.class.getName());
    private final InferenceSession mySession;
    private final List<Pair<InferenceVariable[], PsiClassType>> myCaptures = new ArrayList<Pair<InferenceVariable[], PsiClassType>>();
    private final Map<InferenceVariable, Map<InferenceBound, Set<PsiType>>> myCurrentBounds = new HashMap<InferenceVariable, Map<InferenceBound, Set<PsiType>>>();

    public InferenceIncorporationPhase(InferenceSession session) {
        this.mySession = session;
    }

    public void addCapture(InferenceVariable[] typeParameters2, PsiClassType rightType) {
        this.myCaptures.add(Pair.create(typeParameters2, rightType));
    }

    public void forgetCaptures(List<InferenceVariable> variables) {
        for (InferenceVariable variable : variables) {
            Iterator<Pair<InferenceVariable[], PsiClassType>> iterator2 = this.myCaptures.iterator();
            while (iterator2.hasNext()) {
                Pair<InferenceVariable[], PsiClassType> capture = iterator2.next();
                if (!InferenceIncorporationPhase.isCapturedVariable(variable, capture)) continue;
                iterator2.remove();
            }
        }
    }

    public boolean hasCaptureConstraints(Iterable<InferenceVariable> variables) {
        for (InferenceVariable variable : variables) {
            for (Pair<InferenceVariable[], PsiClassType> capture : this.myCaptures) {
                if (!InferenceIncorporationPhase.isCapturedVariable(variable, capture)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCapturedVariable(InferenceVariable variable, Pair<InferenceVariable[], PsiClassType> capture) {
        for (InferenceVariable capturedVariable : (InferenceVariable[])capture.first) {
            if (variable != capturedVariable) continue;
            return true;
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable variable, Set<InferenceVariable> dependencies) {
        for (Pair<InferenceVariable[], PsiClassType> capture : this.myCaptures) {
            if (!InferenceIncorporationPhase.isCapturedVariable(variable, capture)) continue;
            this.mySession.collectDependencies((PsiType)capture.second, dependencies);
            ContainerUtil.addAll(dependencies, (Object[])capture.first);
        }
    }

    public List<Pair<InferenceVariable[], PsiClassType>> getCaptures() {
        return this.myCaptures;
    }

    public boolean incorporate() {
        Collection<InferenceVariable> inferenceVariables = this.mySession.getInferenceVariables();
        for (InferenceVariable inferenceVariable : inferenceVariables) {
            Map<InferenceBound, Set<PsiType>> boundsMap;
            if (inferenceVariable.getInstantiation() != PsiType.NULL || (boundsMap = this.myCurrentBounds.get(inferenceVariable)) == null) continue;
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            List<PsiType> upperBounds2 = inferenceVariable.getBounds(InferenceBound.UPPER);
            List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            Collection changedEqBounds = boundsMap.get((Object)InferenceBound.EQ);
            Collection changedUpperBounds = boundsMap.get((Object)InferenceBound.UPPER);
            Collection changedLowerBounds = boundsMap.get((Object)InferenceBound.LOWER);
            if (changedEqBounds != null) {
                this.eqEq(eqBounds, changedEqBounds);
            }
            this.upDown(lowerBounds, changedLowerBounds, upperBounds2, changedUpperBounds);
            this.upDown(eqBounds, changedEqBounds, upperBounds2, changedUpperBounds);
            this.upDown(lowerBounds, changedLowerBounds, eqBounds, changedEqBounds);
            if (changedUpperBounds == null) continue;
            this.upUp(upperBounds2);
        }
        for (Pair pair : this.myCaptures) {
            PsiClassType right = (PsiClassType)pair.second;
            PsiClass gClass = right.resolve();
            LOG.assertTrue(gClass != null);
            InferenceVariable[] parameters2 = (InferenceVariable[])pair.first;
            PsiType[] typeArgs = right.getParameters();
            PsiSubstitutor restSubst = PsiSubstitutor.EMPTY;
            if (Registry.is("javac.fresh.variables.for.captured.wildcards.only")) {
                ArrayList<PsiType> args = new ArrayList<PsiType>();
                PsiTypeParameter[] typeParameters2 = gClass.getTypeParameters();
                for (int i = 0; i < typeArgs.length; ++i) {
                    PsiType arg = typeArgs[i];
                    if (arg instanceof PsiWildcardType) {
                        args.add(arg);
                        continue;
                    }
                    restSubst = restSubst.put(typeParameters2[i], arg);
                }
                typeArgs = args.toArray(PsiType.EMPTY_ARRAY);
            }
            if (parameters2.length != typeArgs.length) continue;
            for (int i = 0; i < typeArgs.length; ++i) {
                PsiType aType = typeArgs[i];
                InferenceVariable inferenceVariable = parameters2[i];
                List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
                List<PsiType> upperBounds3 = inferenceVariable.getBounds(InferenceBound.UPPER);
                List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
                if (aType instanceof PsiWildcardType) {
                    for (PsiType eqBound : eqBounds) {
                        if (InferenceIncorporationPhase.isInferenceVariableOrFreshTypeParameter(eqBound).booleanValue()) continue;
                        return false;
                    }
                    PsiClassType[] paramBounds = inferenceVariable.getParameter().getExtendsListTypes();
                    PsiType glb = null;
                    for (PsiClassType paramBound : paramBounds) {
                        glb = glb == null ? paramBound : GenericsUtil.getGreatestLowerBound(glb, paramBound);
                    }
                    glb = restSubst.substitute(glb);
                    if (!((PsiWildcardType)aType).isBounded()) {
                        for (PsiType upperBound : upperBounds3) {
                            if (glb == null || this.mySession.getInferenceVariable(upperBound) != null) continue;
                            this.addConstraint(new StrictSubtypingConstraint(upperBound, this.mySession.substituteWithInferenceVariables(glb)));
                        }
                        for (PsiType lowerBound : lowerBounds) {
                            if (!InferenceIncorporationPhase.isInferenceVariableOrFreshTypeParameter(lowerBound).booleanValue()) continue;
                            return false;
                        }
                        continue;
                    }
                    if (((PsiWildcardType)aType).isExtends()) {
                        PsiType extendsBound = ((PsiWildcardType)aType).getExtendsBound();
                        for (PsiType upperBound : upperBounds3) {
                            if (this.mySession.getInferenceVariable(upperBound) != null) continue;
                            if (paramBounds.length == 1 && paramBounds[0].equalsToText("java.lang.Object") || paramBounds.length == 0) {
                                this.addConstraint(new StrictSubtypingConstraint(upperBound, extendsBound));
                                continue;
                            }
                            if (!extendsBound.equalsToText("java.lang.Object") || glb == null) continue;
                            this.addConstraint(new StrictSubtypingConstraint(upperBound, this.mySession.substituteWithInferenceVariables(glb)));
                        }
                        for (PsiType lowerBound : lowerBounds) {
                            if (!InferenceIncorporationPhase.isInferenceVariableOrFreshTypeParameter(lowerBound).booleanValue()) continue;
                            return false;
                        }
                        continue;
                    }
                    LOG.assertTrue(((PsiWildcardType)aType).isSuper());
                    PsiType superBound = ((PsiWildcardType)aType).getSuperBound();
                    for (PsiType upperBound : upperBounds3) {
                        if (glb == null || this.mySession.getInferenceVariable(upperBound) != null) continue;
                        this.addConstraint(new StrictSubtypingConstraint(this.mySession.substituteWithInferenceVariables(glb), upperBound));
                    }
                    for (PsiType lowerBound : lowerBounds) {
                        if (this.mySession.getInferenceVariable(lowerBound) != null) continue;
                        this.addConstraint(new StrictSubtypingConstraint(superBound, lowerBound));
                    }
                    continue;
                }
                inferenceVariable.addBound(aType, InferenceBound.EQ, this);
            }
        }
        return true;
    }

    protected void upDown(List<PsiType> lowerBounds, Collection<PsiType> changedLowerBounds, List<PsiType> upperBounds2, Collection<PsiType> changedUpperBounds) {
        if (changedLowerBounds != null) {
            this.upDown(changedLowerBounds, upperBounds2);
        }
        if (changedUpperBounds != null) {
            this.upDown(lowerBounds, changedUpperBounds);
        }
    }

    private static Boolean isInferenceVariableOrFreshTypeParameter(PsiType eqBound) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(eqBound);
        if (psiClass instanceof InferenceVariable || psiClass instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)psiClass)) {
            return true;
        }
        return false;
    }

    boolean isFullyIncorporated() {
        boolean needFurtherIncorporation = false;
        for (InferenceVariable inferenceVariable : this.mySession.getInferenceVariables()) {
            Map<InferenceBound, Set<PsiType>> boundsMap;
            if (inferenceVariable.getInstantiation() != PsiType.NULL || (boundsMap = this.myCurrentBounds.remove(inferenceVariable)) == null) continue;
            Set<PsiType> upperBounds2 = boundsMap.get((Object)InferenceBound.UPPER);
            Set<PsiType> lowerBounds = boundsMap.get((Object)InferenceBound.LOWER);
            if (upperBounds2 != null) {
                needFurtherIncorporation |= this.crossVariables(inferenceVariable, upperBounds2, lowerBounds, InferenceBound.LOWER);
            }
            if (lowerBounds == null) continue;
            needFurtherIncorporation |= this.crossVariables(inferenceVariable, lowerBounds, upperBounds2, InferenceBound.UPPER);
        }
        return !needFurtherIncorporation;
    }

    private boolean crossVariables(InferenceVariable inferenceVariable, Collection<PsiType> upperBounds2, Collection<PsiType> lowerBounds, InferenceBound inferenceBound) {
        InferenceBound oppositeBound = inferenceBound == InferenceBound.LOWER ? InferenceBound.UPPER : InferenceBound.LOWER;
        boolean result2 = false;
        for (PsiType upperBound : upperBounds2) {
            InferenceVariable inferenceVar = this.mySession.getInferenceVariable(upperBound);
            if (inferenceVar == null || inferenceVariable == inferenceVar) continue;
            if (lowerBounds != null) {
                for (PsiType lowerBound : lowerBounds) {
                    result2 |= inferenceVar.addBound(lowerBound, inferenceBound, this);
                }
            }
            for (PsiType varUpperBound : inferenceVar.getBounds(oppositeBound)) {
                result2 |= inferenceVariable.addBound(varUpperBound, oppositeBound, this);
            }
        }
        return result2;
    }

    private void upDown(Collection<PsiType> eqBounds, Collection<PsiType> upperBounds2) {
        for (PsiType upperBound : upperBounds2) {
            if (upperBound == null || PsiType.NULL.equals(upperBound) || upperBound instanceof PsiWildcardType) continue;
            for (PsiType eqBound : eqBounds) {
                if (eqBound == null || PsiType.NULL.equals(eqBound) || eqBound instanceof PsiWildcardType) continue;
                if (Registry.is("javac.unchecked.subtyping.during.incorporation", true)) {
                    if (TypeCompatibilityConstraint.isUncheckedConversion(upperBound, eqBound)) {
                        if (!(PsiUtil.resolveClassInType(eqBound) instanceof PsiTypeParameter) || this.mySession.isProperType(upperBound)) continue;
                        this.mySession.setErased();
                        continue;
                    }
                    if (!this.mySession.isProperType(upperBound) && eqBound instanceof PsiCapturedWildcardType && TypeCompatibilityConstraint.isUncheckedConversion(upperBound, ((PsiCapturedWildcardType)eqBound).getUpperBound())) {
                        this.mySession.setErased();
                        continue;
                    }
                }
                this.addConstraint(new StrictSubtypingConstraint(upperBound, eqBound));
            }
        }
    }

    private void eqEq(List<PsiType> eqBounds, Collection<PsiType> changedEqBounds) {
        for (int i = 0; i < eqBounds.size(); ++i) {
            PsiType sBound = eqBounds.get(i);
            boolean changed = changedEqBounds.contains(sBound);
            for (int j = i + 1; j < eqBounds.size(); ++j) {
                PsiType tBound = eqBounds.get(j);
                if (!changed && !changedEqBounds.contains(tBound)) continue;
                this.addConstraint(new TypeEqualityConstraint(tBound, sBound));
            }
        }
    }

    private boolean upUp(List<PsiType> upperBounds2) {
        return InferenceSession.findParameterizationOfTheSameGenericClass(upperBounds2, pair -> {
            PsiType sType = (PsiType)pair.first;
            PsiType tType = (PsiType)pair.second;
            if (!(sType instanceof PsiWildcardType) && !(tType instanceof PsiWildcardType) && sType != null && tType != null) {
                this.addConstraint(new TypeEqualityConstraint(sType, tType));
            }
            return false;
        }) != null;
    }

    private void addConstraint(ConstraintFormula constraint) {
        this.mySession.addConstraint(constraint);
    }

    public void addBound(InferenceVariable variable, PsiType type2, InferenceBound bound) {
        Set<PsiType> types;
        Map<InferenceBound, Set<PsiType>> bounds = this.myCurrentBounds.get(variable);
        if (bounds == null) {
            bounds = new HashMap<InferenceBound, Set<PsiType>>();
            this.myCurrentBounds.put(variable, bounds);
        }
        if ((types = bounds.get((Object)bound)) == null) {
            types = new LinkedHashSet<PsiType>();
            bounds.put(bound, types);
        }
        types.add(type2);
    }
}

