/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;

public class KtPropertyElementType
extends KtStubElementType<KotlinPropertyStub, KtProperty> {
    public KtPropertyElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtPropertyElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtProperty.class, KotlinPropertyStub.class);
    }

    @Override
    public KotlinPropertyStub createStub(@NotNull KtProperty psi, StubElement parentStub) {
        if (psi == null) {
            KtPropertyElementType.$$$reportNull$$$0(1);
        }
        assert (!psi.isLocal()) : String.format("Should not store local property: %s, parent %s", psi.getText(), psi.getParent() != null ? psi.getParent().getText() : "<no parent>");
        return new KotlinPropertyStubImpl(parentStub, StringRef.fromString(psi.getName()), psi.isVar(), psi.isTopLevel(), psi.hasDelegate(), psi.hasDelegateExpression(), psi.hasInitializer(), psi.getReceiverTypeReference() != null, psi.getTypeReference() != null, ResolveSessionUtils.safeFqNameForLazyResolve(psi));
    }

    @Override
    public void serialize(@NotNull KotlinPropertyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            KtPropertyElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            KtPropertyElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isVar());
        dataStream.writeBoolean(stub.isTopLevel());
        dataStream.writeBoolean(stub.hasDelegate());
        dataStream.writeBoolean(stub.hasDelegateExpression());
        dataStream.writeBoolean(stub.hasInitializer());
        dataStream.writeBoolean(stub.isExtension());
        dataStream.writeBoolean(stub.hasReturnTypeRef());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.asString() : null);
    }

    @Override
    @NotNull
    public KotlinPropertyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtPropertyElementType.$$$reportNull$$$0(4);
        }
        StringRef name = dataStream.readName();
        boolean isVar = dataStream.readBoolean();
        boolean isTopLevel = dataStream.readBoolean();
        boolean hasDelegate = dataStream.readBoolean();
        boolean hasDelegateExpression = dataStream.readBoolean();
        boolean hasInitializer = dataStream.readBoolean();
        boolean hasReceiverTypeRef = dataStream.readBoolean();
        boolean hasReturnTypeRef = dataStream.readBoolean();
        StringRef fqNameAsString = dataStream.readName();
        FqName fqName2 = fqNameAsString != null ? new FqName(fqNameAsString.toString()) : null;
        KotlinPropertyStubImpl kotlinPropertyStubImpl = new KotlinPropertyStubImpl(parentStub, name, isVar, isTopLevel, hasDelegate, hasDelegateExpression, hasInitializer, hasReceiverTypeRef, hasReturnTypeRef, fqName2);
        if (kotlinPropertyStubImpl == null) {
            KtPropertyElementType.$$$reportNull$$$0(5);
        }
        return kotlinPropertyStubImpl;
    }

    @Override
    public void indexStub(@NotNull KotlinPropertyStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            KtPropertyElementType.$$$reportNull$$$0(6);
        }
        if (sink == null) {
            KtPropertyElementType.$$$reportNull$$$0(7);
        }
        StubIndexService.getInstance().indexProperty(stub, sink);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

