/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.Hasher;

public class Hashing {
    private static final HashFunction MD5 = MessageDigestHashFunction.of("MD5");
    private static final HashFunction SHA1 = MessageDigestHashFunction.of("SHA-1");

    private Hashing() {
    }

    public static HashFunction md5() {
        return MD5;
    }

    public static HashFunction sha1() {
        return SHA1;
    }

    private static class MessageDigestHasher
    implements Hasher {
        private final MessageDigest digest;
        private final ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        private boolean done;

        public MessageDigestHasher(MessageDigest digest) {
            this.digest = digest;
        }

        private void checkNotDone() {
            if (this.done) {
                throw new IllegalStateException("Cannot reuse hasher");
            }
        }

        public void putByte(byte b) {
            this.checkNotDone();
            this.digest.update(b);
        }

        public void putBytes(byte[] bytes) {
            this.checkNotDone();
            this.digest.update(bytes);
        }

        public void putBytes(byte[] bytes, int off, int len) {
            this.checkNotDone();
            this.digest.update(bytes, off, len);
        }

        public HashCode hash() {
            this.done = true;
            byte[] bytes = this.digest.digest();
            return HashCode.fromBytesNoCopy(bytes);
        }

        private void update(int length) {
            this.checkNotDone();
            this.digest.update(this.buffer.array(), 0, length);
            this.buffer.clear();
        }

        public void putInt(int value) {
            this.buffer.putInt(value);
            this.update(4);
        }

        public void putLong(long value) {
            this.buffer.putLong(value);
            this.update(8);
        }

        public void putDouble(double value) {
            long longValue = Double.doubleToRawLongBits(value);
            this.putLong(longValue);
        }

        public void putBoolean(boolean value) {
            this.checkNotDone();
            this.putByte((byte)(value ? 1 : 0));
        }

        public void putString(CharSequence value) {
            this.putBytes(value.toString().getBytes(Charsets.UTF_8));
        }

        public void putHash(HashCode hashCode) {
            this.putBytes(hashCode.getBytes());
        }
    }

    private static class RegularMessageDigestHashFunction
    extends MessageDigestHashFunction {
        private final String algorithm;

        public RegularMessageDigestHashFunction(String algorithm) {
            this.algorithm = algorithm;
        }

        protected MessageDigest createDigest() {
            try {
                return MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static class CloningMessageDigestHashFunction
    extends MessageDigestHashFunction {
        private final MessageDigest prototype;

        public CloningMessageDigestHashFunction(MessageDigest prototype) {
            this.prototype = prototype;
        }

        protected MessageDigest createDigest() {
            try {
                return (MessageDigest)this.prototype.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static abstract class MessageDigestHashFunction
    implements HashFunction {
        private MessageDigestHashFunction() {
        }

        public static MessageDigestHashFunction of(String algorithm) {
            MessageDigest prototype;
            try {
                prototype = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Cannot instantiate digest algorithm: " + algorithm);
            }
            try {
                prototype.clone();
                return new CloningMessageDigestHashFunction(prototype);
            }
            catch (CloneNotSupportedException e) {
                return new RegularMessageDigestHashFunction(algorithm);
            }
        }

        public Hasher newHasher() {
            MessageDigest digest = this.createDigest();
            return new MessageDigestHasher(digest);
        }

        public HashCode hashBytes(byte[] bytes) {
            Hasher hasher = this.newHasher();
            hasher.putBytes(bytes);
            return hasher.hash();
        }

        public HashCode hashString(CharSequence string) {
            Hasher hasher = this.newHasher();
            hasher.putString(string);
            return hasher.hash();
        }

        protected abstract MessageDigest createDigest();
    }
}

