/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.util.Arrays;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.nativeplatform.internal.DefaultNativeComponent;
import org.gradle.language.nativeplatform.internal.Names;

public abstract class DefaultCppComponent
extends DefaultNativeComponent
implements CppComponent {
    private final FileCollection cppSource;
    private final String name;
    private final FileOperations fileOperations;
    private final ConfigurableFileCollection privateHeaders;
    private final FileCollection privateHeadersWithConvention;
    private final PropertyState<String> baseName;
    private final Names names;
    private final Configuration implementation;

    @Inject
    public DefaultCppComponent(String name, FileOperations fileOperations, ProviderFactory providerFactory, ConfigurationContainer configurations) {
        super(fileOperations);
        this.name = name;
        this.fileOperations = fileOperations;
        this.cppSource = this.createSourceView("src/" + name + "/cpp", Arrays.asList("cpp", "c++"));
        this.privateHeaders = fileOperations.files(new Object[0]);
        this.privateHeadersWithConvention = this.createDirView(this.privateHeaders, "src/" + name + "/headers");
        this.baseName = providerFactory.property(String.class);
        this.names = Names.of(name);
        this.implementation = (Configuration)configurations.create(this.names.withSuffix("implementation"));
        this.implementation.setCanBeConsumed(false);
        this.implementation.setCanBeResolved(false);
    }

    protected Names getNames() {
        return this.names;
    }

    public String getName() {
        return this.name;
    }

    protected FileCollection createDirView(final ConfigurableFileCollection dirs, final String conventionLocation) {
        return this.fileOperations.files(new Object[]{new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (dirs.getFrom().isEmpty()) {
                    return DefaultCppComponent.this.fileOperations.files(new Object[]{conventionLocation});
                }
                return dirs;
            }
        }});
    }

    @Override
    public PropertyState<String> getBaseName() {
        return this.baseName;
    }

    @Override
    public FileCollection getCppSource() {
        return this.cppSource;
    }

    @Override
    public ConfigurableFileCollection getPrivateHeaders() {
        return this.privateHeaders;
    }

    @Override
    public void privateHeaders(Action<? super ConfigurableFileCollection> action) {
        action.execute((Object)this.privateHeaders);
    }

    @Override
    public FileCollection getPrivateHeaderDirs() {
        return this.privateHeadersWithConvention;
    }

    @Override
    public Configuration getImplementationDependencies() {
        return this.implementation;
    }

    @Override
    public FileTree getHeaderFiles() {
        return this.getAllHeaderDirs().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.h"}));
    }

    protected FileCollection getAllHeaderDirs() {
        return this.privateHeadersWithConvention;
    }
}

