/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.internal.DefaultCppLibrary;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public class CppLibraryPlugin
implements Plugin<ProjectInternal> {
    private final FileOperations fileOperations;

    @Inject
    public CppLibraryPlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        DirectoryVar buildDirectory = project.getLayout().getBuildDirectory();
        ObjectFactory objectFactory = project.getObjects();
        ProviderFactory providers = project.getProviders();
        final CppLibrary library = (CppLibrary)project.getExtensions().create(CppLibrary.class, "library", DefaultCppLibrary.class, new Object[]{"main", project.getObjects(), this.fileOperations, providers, project.getConfigurations()});
        project.getComponents().add((Object)library);
        project.getComponents().add((Object)library.getDebugSharedLibrary());
        project.getComponents().add((Object)library.getReleaseSharedLibrary());
        library.getBaseName().set((Object)project.getName());
        final LinkSharedLibrary linkDebug = (LinkSharedLibrary)tasks.getByName("linkDebug");
        final PlatformToolProvider platformToolChain = ((NativeToolChainInternal)linkDebug.getToolChain()).select((NativePlatformInternal)linkDebug.getTargetPlatform());
        Provider debugLinkFile = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return platformToolChain.getSharedLibraryLinkFileName("lib/main/debug/" + (String)library.getBaseName().get());
            }
        }));
        final LinkSharedLibrary linkRelease = (LinkSharedLibrary)tasks.getByName("linkRelease");
        Provider releaseLinkFile = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return platformToolChain.getSharedLibraryLinkFileName("lib/main/release/" + (String)library.getBaseName().get());
            }
        }));
        tasks.getByName("assemble").dependsOn(new Object[]{linkDebug});
        Configuration apiElements = (Configuration)configurations.create("cppApiElements");
        apiElements.extendsFrom(new Configuration[]{library.getApiDependencies()});
        apiElements.setCanBeResolved(false);
        apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "cplusplus-api"));
        Provider publicHeaders = providers.provider((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                Set files = library.getPublicHeaderDirs().getFiles();
                if (files.size() != 1) {
                    throw new UnsupportedOperationException(String.format("The C++ library plugin currently requires exactly one public header directory, however there are %d directories configured: %s", files.size(), files));
                }
                return (File)files.iterator().next();
            }
        });
        apiElements.getOutgoing().artifact((Object)publicHeaders);
        Configuration implementation = library.getImplementationDependencies();
        Configuration debugLinkElements = (Configuration)configurations.create("debugLinkElements");
        debugLinkElements.extendsFrom(new Configuration[]{implementation});
        debugLinkElements.setCanBeResolved(false);
        debugLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-link"));
        debugLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugLinkElements.getOutgoing().artifact((Object)debugLinkFile, (Action)new Action<ConfigurablePublishArtifact>(){

            public void execute(ConfigurablePublishArtifact artifact) {
                artifact.builtBy(new Object[]{linkDebug});
            }
        });
        Configuration debugRuntimeElements = (Configuration)configurations.create("debugRuntimeElements");
        debugRuntimeElements.extendsFrom(new Configuration[]{implementation});
        debugRuntimeElements.setCanBeResolved(false);
        debugRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-runtime"));
        debugRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugRuntimeElements.getOutgoing().artifact((Object)linkDebug.getBinaryFile());
        Configuration releaseLinkElements = (Configuration)configurations.create("releaseLinkElements");
        releaseLinkElements.extendsFrom(new Configuration[]{implementation});
        releaseLinkElements.setCanBeResolved(false);
        releaseLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-link"));
        releaseLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseLinkElements.getOutgoing().artifact((Object)releaseLinkFile, (Action)new Action<ConfigurablePublishArtifact>(){

            public void execute(ConfigurablePublishArtifact artifact) {
                artifact.builtBy(new Object[]{linkRelease});
            }
        });
        Configuration releaseRuntimeElements = (Configuration)configurations.create("releaseRuntimeElements");
        releaseRuntimeElements.extendsFrom(new Configuration[]{implementation});
        releaseRuntimeElements.setCanBeResolved(false);
        releaseRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-runtime"));
        releaseRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseRuntimeElements.getOutgoing().artifact((Object)linkRelease.getBinaryFile());
    }
}

