/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.CSourceParser;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultInclude;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultIncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.PreprocessingReader;

public class RegexBackedCSourceParser
implements CSourceParser {
    private static final String INCLUDE_IMPORT_PATTERN = "#\\s*(include|import)\\s*((<[^>]+>)|(\"[^\"]+\")|(\\w+))";
    private final Pattern includePattern = Pattern.compile("#\\s*(include|import)\\s*((<[^>]+>)|(\"[^\"]+\")|(\\w+))", 2);

    @Override
    public IncludeDirectives parseSource(File sourceFile) {
        return new DefaultIncludeDirectives(this.parseFile(sourceFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Include> parseFile(File file) {
        ArrayList includes = Lists.newArrayList();
        try {
            BufferedReader bf = new BufferedReader((Reader)((Object)new PreprocessingReader(new BufferedReader(new FileReader(file)))));
            try {
                String line;
                while ((line = bf.readLine()) != null) {
                    Matcher m = this.includePattern.matcher(line.trim());
                    if (!m.matches()) continue;
                    boolean isImport = "import".equals(m.group(1));
                    String value = m.group(2);
                    includes.add(DefaultInclude.parse(value, isImport));
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)bf);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return includes;
    }
}

