/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import org.gradle.api.Named;
import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.util.VersionNumber;

public class Ucrt
implements Named {
    private final File baseDir;
    private final String name;
    private final VersionNumber version;

    public Ucrt(File baseDir, String name, VersionNumber version) {
        this.baseDir = baseDir;
        this.name = name;
        this.version = version;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public String getName() {
        return this.name;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    public File[] getIncludeDirs() {
        return new File[]{new File(new File(new File(this.baseDir, "Include"), this.version.toString()), "ucrt")};
    }

    public File getLibDir(NativePlatformInternal platform) {
        String platformDir = "x86";
        if (this.architecture(platform).isAmd64()) {
            platformDir = "x64";
        }
        if (this.architecture(platform).isArm()) {
            platformDir = "arm";
        }
        return new File(new File(new File(new File(this.baseDir, "Lib"), this.version.toString()), "ucrt"), platformDir);
    }

    private ArchitectureInternal architecture(NativePlatformInternal platform) {
        return platform.getArchitecture();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ucrt ucrt = (Ucrt)o;
        if (!this.baseDir.equals(ucrt.baseDir)) {
            return false;
        }
        if (!this.name.equals(ucrt.name)) {
            return false;
        }
        return this.version.equals((Object)ucrt.version);
    }

    public int hashCode() {
        int result = this.baseDir.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }
}

