/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.maven.MavenDeployment;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SignOperation;
import org.gradle.plugins.signing.Signature;
import org.gradle.plugins.signing.SignatureSpec;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.plugins.signing.signatory.SignatoryProvider;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatoryProvider;
import org.gradle.plugins.signing.type.DefaultSignatureTypeProvider;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.plugins.signing.type.SignatureTypeProvider;
import org.gradle.util.GUtil;

public class SigningExtension {
    public static final String DEFAULT_CONFIGURATION_NAME = "signatures";
    private final Project project;
    private Configuration configuration;
    private Object required = true;
    private SignatureTypeProvider signatureTypes;
    private SignatoryProvider signatories;

    public SigningExtension(Project project) {
        this.project = project;
        this.configuration = this.getDefaultConfiguration();
        this.signatureTypes = this.createSignatureTypeProvider();
        this.signatories = this.createSignatoryProvider();
        project.getTasks().withType(Sign.class, (Action)new Action<Sign>(){

            public void execute(Sign task) {
                SigningExtension.this.addSignatureSpecConventions(task);
            }
        });
    }

    public final Project getProject() {
        return this.project;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setRequired(Object required) {
        this.required = required;
    }

    public boolean isRequired() {
        return DefaultTypeTransformation.castToBoolean((Object)this.force(this.required));
    }

    protected Configuration getDefaultConfiguration() {
        ConfigurationContainer configurations = this.project.getConfigurations();
        Configuration configuration = (Configuration)configurations.findByName(DEFAULT_CONFIGURATION_NAME);
        return configuration != null ? configuration : (Configuration)configurations.create(DEFAULT_CONFIGURATION_NAME);
    }

    protected SignatureTypeProvider createSignatureTypeProvider() {
        return new DefaultSignatureTypeProvider();
    }

    protected SignatoryProvider createSignatoryProvider() {
        return new PgpSignatoryProvider();
    }

    public SignatoryProvider signatories(Closure closure) {
        this.signatories.configure(this, closure);
        return this.signatories;
    }

    public Signatory getSignatory() {
        return this.signatories.getDefaultSignatory(this.project);
    }

    public SignatureType getSignatureType() {
        return this.signatureTypes.getDefaultType();
    }

    public void setSignatureTypes(SignatureTypeProvider signatureTypes) {
        this.signatureTypes = signatureTypes;
    }

    public SignatureTypeProvider getSignatureTypes() {
        return this.signatureTypes;
    }

    public void setSignatories(SignatoryProvider signatories) {
        this.signatories = signatories;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected void addSignatureSpecConventions(SignatureSpec spec) {
        if (!(spec instanceof IConventionAware)) {
            throw new InvalidUserDataException("Cannot add conventions to signature spec '" + String.valueOf(spec) + "' as it is not convention aware");
        }
        ConventionMapping conventionMapping = ((IConventionAware)spec).getConventionMapping();
        conventionMapping.map("signatory", (Callable)new Callable<Signatory>(){

            @Override
            public Signatory call() {
                return SigningExtension.this.getSignatory();
            }
        });
        conventionMapping.map("signatureType", (Callable)new Callable<SignatureType>(){

            @Override
            public SignatureType call() {
                return SigningExtension.this.getSignatureType();
            }
        });
        conventionMapping.map("required", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return SigningExtension.this.isRequired();
            }
        });
    }

    public List<Sign> sign(Task ... tasks) {
        ArrayList<Sign> result = new ArrayList<Sign>(tasks.length);
        for (final Task taskToSign : tasks) {
            result.add(this.createSignTaskFor(taskToSign.getName(), new Action<Sign>(){

                public void execute(Sign task) {
                    task.sign(taskToSign);
                }
            }));
        }
        return result;
    }

    public List<Sign> sign(Configuration ... configurations) {
        ArrayList<Sign> result = new ArrayList<Sign>(configurations.length);
        for (final Configuration configurationToSign : configurations) {
            result.add(this.createSignTaskFor(configurationToSign.getName(), new Action<Sign>(){

                public void execute(Sign task) {
                    task.sign(configurationToSign);
                }
            }));
        }
        return result;
    }

    private Sign createSignTaskFor(CharSequence name, Action<Sign> taskConfiguration) {
        Sign signTask = (Sign)this.project.getTasks().create("sign" + StringGroovyMethods.capitalize((CharSequence)name), Sign.class, taskConfiguration);
        this.addSignaturesToConfiguration(signTask, this.getConfiguration());
        return signTask;
    }

    protected Object addSignaturesToConfiguration(Sign task, final Configuration configuration) {
        task.getSignatures().all((Action)new Action<Signature>(){

            public void execute(Signature sig) {
                configuration.getArtifacts().add((Object)sig);
            }
        });
        return task.getSignatures().whenObjectRemoved((Action)new Action<Signature>(){

            public void execute(Signature sig) {
                configuration.getArtifacts().remove((Object)sig);
            }
        });
    }

    public SignOperation sign(final PublishArtifact ... publishArtifacts) {
        return this.doSignOperation(new Action<SignOperation>(){

            public void execute(SignOperation operation) {
                operation.sign(publishArtifacts);
            }
        });
    }

    public SignOperation sign(final File ... files) {
        return this.doSignOperation(new Action<SignOperation>(){

            public void execute(SignOperation operation) {
                operation.sign(files);
            }
        });
    }

    public SignOperation sign(final String classifier, final File ... files) {
        return this.doSignOperation(new Action<SignOperation>(){

            public void execute(SignOperation operation) {
                operation.sign(classifier, files);
            }
        });
    }

    public SignOperation sign(Closure closure) {
        return this.doSignOperation(closure);
    }

    public Signature signPom(final MavenDeployment mavenDeployment, final Closure closure) {
        SignOperation signOperation = this.doSignOperation(new Action<SignOperation>(){

            public void execute(SignOperation so) {
                so.sign(mavenDeployment.getPomArtifact());
                so.configure(closure);
            }
        });
        Signature pomSignature = signOperation.getSingleSignature();
        if (!pomSignature.getFile().exists()) {
            return null;
        }
        pomSignature.setType("pom." + pomSignature.getSignatureType().getExtension());
        mavenDeployment.addArtifact((PublishArtifact)pomSignature);
        return pomSignature;
    }

    public Signature signPom(MavenDeployment mavenDeployment) {
        return this.signPom(mavenDeployment, null);
    }

    protected SignOperation doSignOperation(final Closure setup) {
        return this.doSignOperation(new Action<SignOperation>(){

            public void execute(SignOperation operation) {
                operation.configure(setup);
            }
        });
    }

    protected SignOperation doSignOperation(Action<SignOperation> setup) {
        SignOperation operation = (SignOperation)this.instantiator().newInstance(SignOperation.class, new Object[0]);
        this.addSignatureSpecConventions(operation);
        setup.execute((Object)operation);
        operation.execute();
        return operation;
    }

    private Instantiator instantiator() {
        return (Instantiator)((ProjectInternal)this.project).getServices().get(Instantiator.class);
    }

    public SignatoryProvider getSignatories() {
        return this.signatories;
    }

    private Object force(Object maybeCallable) {
        return maybeCallable instanceof Callable ? GUtil.uncheckedCall((Callable)((Callable)maybeCallable)) : maybeCallable;
    }
}

