/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.service.internal;

import java.io.Closeable;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.resolve.service.internal.ClientStatus;
import org.gradle.plugin.use.resolve.service.internal.ErrorResponse;
import org.gradle.plugin.use.resolve.service.internal.PluginUseMetaData;

@ThreadSafe
public interface PluginResolutionServiceClient
extends Closeable {
    public Response<PluginUseMetaData> queryPluginMetadata(String var1, boolean var2, PluginRequestInternal var3);

    public Response<ClientStatus> queryClientStatus(String var1, boolean var2, @Nullable String var3);

    public static class SuccessResponse<T>
    implements Response<T> {
        private final T response;
        private final int statusCode;
        private final String url;
        private final String clientStatusChecksum;

        public SuccessResponse(T response, int statusCode, String url, String clientStatusChecksum) {
            this.response = response;
            this.statusCode = statusCode;
            this.url = url;
            this.clientStatusChecksum = clientStatusChecksum;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getClientStatusChecksum() {
            return this.clientStatusChecksum;
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public ErrorResponse getErrorResponse() {
            return null;
        }

        @Override
        public T getResponse() {
            return this.response;
        }
    }

    public static class ErrorResponseResponse<T>
    implements Response<T> {
        private final ErrorResponse errorResponse;
        private final int statusCode;
        private final String url;
        private final String clientStatusChecksum;

        public ErrorResponseResponse(ErrorResponse errorResponse, int statusCode, String url, String clientStatusChecksum) {
            this.errorResponse = errorResponse;
            this.statusCode = statusCode;
            this.url = url;
            this.clientStatusChecksum = clientStatusChecksum;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getClientStatusChecksum() {
            return this.clientStatusChecksum;
        }

        @Override
        public boolean isError() {
            return true;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public ErrorResponse getErrorResponse() {
            return this.errorResponse;
        }

        @Override
        public T getResponse() {
            return null;
        }
    }

    public static interface Response<T> {
        public boolean isError();

        public int getStatusCode();

        public ErrorResponse getErrorResponse();

        public T getResponse();

        public String getUrl();

        @Nullable
        public String getClientStatusChecksum();
    }
}

