/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.FilePath;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.SingleEntryModuleLibrary;
import org.gradle.plugins.ide.idea.model.internal.GeneratedIdeaScope;
import org.gradle.plugins.ide.idea.model.internal.ModuleDependencyBuilder;
import org.gradle.plugins.ide.internal.IdeDependenciesExtractor;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeProjectDependency;
import org.gradle.plugins.ide.internal.resolver.model.UnresolvedIdeRepoFileDependency;

public class IdeaDependenciesProvider {
    public static final String SCOPE_PLUS = "plus";
    public static final String SCOPE_MINUS = "minus";
    private final IdeDependenciesExtractor dependenciesExtractor;
    private final ModuleDependencyBuilder moduleDependencyBuilder;

    public IdeaDependenciesProvider(ServiceRegistry serviceRegistry) {
        this(new IdeDependenciesExtractor(), serviceRegistry);
    }

    IdeaDependenciesProvider(IdeDependenciesExtractor dependenciesExtractor, ServiceRegistry serviceRegistry) {
        this.dependenciesExtractor = dependenciesExtractor;
        this.moduleDependencyBuilder = new ModuleDependencyBuilder((LocalComponentRegistry)serviceRegistry.get(LocalComponentRegistry.class));
    }

    public Set<Dependency> provide(IdeaModule ideaModule) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.addAll(this.getOutputLocations(ideaModule));
        result.addAll(this.getDependencies(ideaModule));
        return result;
    }

    private Set<SingleEntryModuleLibrary> getOutputLocations(IdeaModule ideaModule) {
        if (ideaModule.getSingleEntryLibraries() == null) {
            return Collections.emptySet();
        }
        LinkedHashSet outputLocations = Sets.newLinkedHashSet();
        for (Map.Entry<String, Iterable<File>> outputLocation : ideaModule.getSingleEntryLibraries().entrySet()) {
            String scope = outputLocation.getKey();
            for (File file : outputLocation.getValue()) {
                if (file == null || !file.isDirectory()) continue;
                outputLocations.add(new SingleEntryModuleLibrary(this.toPath(ideaModule, file), scope));
            }
        }
        return outputLocations;
    }

    private Set<Dependency> getDependencies(IdeaModule ideaModule) {
        LinkedHashSet dependencies = Sets.newLinkedHashSet();
        for (GeneratedIdeaScope scope : GeneratedIdeaScope.values()) {
            dependencies.addAll(this.getProjectDependencies(ideaModule, scope));
            dependencies.addAll(this.getExternalDependencies(ideaModule, scope));
            dependencies.addAll(this.getFileDependencies(ideaModule, scope));
        }
        return dependencies;
    }

    private Set<Dependency> getProjectDependencies(IdeaModule ideaModule, GeneratedIdeaScope scope) {
        Collection<Configuration> plusConfigurations = this.getPlusConfigurations(ideaModule, scope);
        Collection<Configuration> minusConfigurations = this.getMinusConfigurations(ideaModule, scope);
        Collection<IdeProjectDependency> extractedDependencies = this.dependenciesExtractor.extractProjectDependencies(ideaModule.getProject(), plusConfigurations, minusConfigurations);
        LinkedHashSet dependencies = Sets.newLinkedHashSet();
        for (IdeProjectDependency ideProjectDependency : extractedDependencies) {
            dependencies.add(this.moduleDependencyBuilder.create(ideProjectDependency, scope.name()));
        }
        return dependencies;
    }

    private Set<Dependency> getExternalDependencies(IdeaModule ideaModule, GeneratedIdeaScope scope) {
        if (ideaModule.isOffline()) {
            return Collections.emptySet();
        }
        Collection<Configuration> plusConfigurations = this.getPlusConfigurations(ideaModule, scope);
        Collection<Configuration> minusConfigurations = this.getMinusConfigurations(ideaModule, scope);
        LinkedHashSet dependencies = Sets.newLinkedHashSet();
        Collection<IdeExtendedRepoFileDependency> ideRepoFileDependencies = this.dependenciesExtractor.extractRepoFileDependencies(ideaModule.getProject().getDependencies(), plusConfigurations, minusConfigurations, ideaModule.isDownloadSources(), ideaModule.isDownloadJavadoc());
        for (IdeExtendedRepoFileDependency dependency : ideRepoFileDependencies) {
            dependencies.add(this.toLibraryDependency(dependency, ideaModule, scope));
        }
        return dependencies;
    }

    private SingleEntryModuleLibrary toLibraryDependency(IdeExtendedRepoFileDependency dependency, IdeaModule ideaModule, GeneratedIdeaScope scope) {
        LinkedHashSet javadoc = Sets.newLinkedHashSet();
        for (File javaDocFile : dependency.getJavadocFiles()) {
            javadoc.add(this.toPath(ideaModule, javaDocFile));
        }
        LinkedHashSet source = Sets.newLinkedHashSet();
        for (File sourceFile : dependency.getSourceFiles()) {
            source.add(this.toPath(ideaModule, sourceFile));
        }
        SingleEntryModuleLibrary library = new SingleEntryModuleLibrary(this.toPath(ideaModule, dependency.getFile()), javadoc, source, scope.name());
        library.setModuleVersion(dependency.getId());
        return library;
    }

    private Set<Dependency> getFileDependencies(IdeaModule ideaModule, GeneratedIdeaScope scope) {
        Collection<Configuration> plusConfigurations = this.getPlusConfigurations(ideaModule, scope);
        Collection<Configuration> minusConfigurations = this.getMinusConfigurations(ideaModule, scope);
        LinkedHashSet dependencies = Sets.newLinkedHashSet();
        Collection<IdeLocalFileDependency> ideLocalFileDependencies = this.dependenciesExtractor.extractLocalFileDependencies(plusConfigurations, minusConfigurations);
        for (IdeLocalFileDependency fileDependency : ideLocalFileDependencies) {
            dependencies.add(this.toLibraryDependency(fileDependency, ideaModule, scope));
        }
        return dependencies;
    }

    private SingleEntryModuleLibrary toLibraryDependency(IdeLocalFileDependency fileDependency, IdeaModule ideaModule, GeneratedIdeaScope scope) {
        return new SingleEntryModuleLibrary(this.toPath(ideaModule, fileDependency.getFile()), scope.name());
    }

    public Collection<UnresolvedIdeRepoFileDependency> getUnresolvedDependencies(IdeaModule ideaModule) {
        TreeSet usedUnresolvedDependencies = Sets.newTreeSet((Comparator)new Comparator<UnresolvedIdeRepoFileDependency>(){

            @Override
            public int compare(UnresolvedIdeRepoFileDependency left, UnresolvedIdeRepoFileDependency right) {
                return left.getDisplayName().compareTo(right.getDisplayName());
            }
        });
        for (GeneratedIdeaScope scope : GeneratedIdeaScope.values()) {
            Collection<Configuration> plusConfigurations = this.getPlusConfigurations(ideaModule, scope);
            Collection<Configuration> minusConfigurations = this.getMinusConfigurations(ideaModule, scope);
            usedUnresolvedDependencies.addAll(this.dependenciesExtractor.unresolvedExternalDependencies(plusConfigurations, minusConfigurations));
        }
        return usedUnresolvedDependencies;
    }

    private Collection<Configuration> getPlusConfigurations(IdeaModule ideaModule, GeneratedIdeaScope scope) {
        return this.getConfigurations(ideaModule, scope, SCOPE_PLUS);
    }

    private Collection<Configuration> getMinusConfigurations(IdeaModule ideaModule, GeneratedIdeaScope scope) {
        return this.getConfigurations(ideaModule, scope, SCOPE_MINUS);
    }

    private Collection<Configuration> getConfigurations(IdeaModule ideaModule, GeneratedIdeaScope scope, String plusMinus) {
        Map<String, Collection<Configuration>> plusMinusConfigurations = this.getPlusMinusConfigurations(ideaModule, scope);
        return plusMinusConfigurations.containsKey(plusMinus) ? plusMinusConfigurations.get(plusMinus) : Collections.emptyList();
    }

    private Map<String, Collection<Configuration>> getPlusMinusConfigurations(IdeaModule ideaModule, GeneratedIdeaScope scope) {
        Map<String, Collection<Configuration>> plusMinusConfigurations = ideaModule.getScopes().get(scope.name());
        return plusMinusConfigurations != null ? plusMinusConfigurations : Collections.emptyMap();
    }

    private FilePath toPath(IdeaModule ideaModule, File file) {
        return file != null ? ideaModule.getPathFactory().path(file) : null;
    }
}

