/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.DefaultCppApplication;
import org.gradle.language.cpp.internal.MainExecutableVariant;
import org.gradle.language.cpp.internal.NativeRuntimeVariant;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;

@Incubating
public class CppExecutablePlugin
implements Plugin<ProjectInternal> {
    private final FileOperations fileOperations;

    @Inject
    public CppExecutablePlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        ConfigurationContainer configurations = project.getConfigurations();
        TaskContainerInternal tasks = project.getTasks();
        ObjectFactory objectFactory = project.getObjects();
        final CppApplication application = (CppApplication)project.getExtensions().create(CppApplication.class, "executable", DefaultCppApplication.class, new Object[]{"main", objectFactory, this.fileOperations, configurations});
        project.getComponents().add((Object)application);
        project.getComponents().add((Object)application.getDebugExecutable());
        project.getComponents().add((Object)application.getReleaseExecutable());
        application.getBaseName().set((Object)project.getName());
        InstallExecutable install = (InstallExecutable)tasks.getByName("installDebug");
        tasks.getByName("assemble").dependsOn(new Object[]{install});
        LinkExecutable linkDebug = (LinkExecutable)tasks.getByName("linkDebug");
        LinkExecutable linkRelease = (LinkExecutable)tasks.getByName("linkRelease");
        final Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
        final Configuration debugRuntimeElements = (Configuration)configurations.maybeCreate("debugRuntimeElements");
        debugRuntimeElements.extendsFrom(new Configuration[]{application.getImplementationDependencies()});
        debugRuntimeElements.setCanBeResolved(false);
        debugRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        debugRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugRuntimeElements.getOutgoing().artifact((Object)linkDebug.getBinaryFile());
        final Configuration releaseRuntimeElements = (Configuration)configurations.maybeCreate("releaseRuntimeElements");
        releaseRuntimeElements.extendsFrom(new Configuration[]{application.getImplementationDependencies()});
        releaseRuntimeElements.setCanBeResolved(false);
        releaseRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
        releaseRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseRuntimeElements.getOutgoing().artifact((Object)linkRelease.getBinaryFile());
        project.getPluginManager().withPlugin("maven-publish", (Action)new Action<AppliedPlugin>(){

            public void execute(AppliedPlugin appliedPlugin) {
                final MainExecutableVariant mainVariant = new MainExecutableVariant();
                project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

                    public void execute(PublishingExtension extension) {
                        extension.getPublications().create("main", MavenPublication.class, (Action)new Action<MavenPublication>(){

                            public void execute(MavenPublication publication) {
                                publication.setGroupId(project.getGroup().toString());
                                publication.setArtifactId((String)application.getBaseName().get());
                                publication.setVersion(project.getVersion().toString());
                                publication.from((SoftwareComponent)mainVariant);
                            }
                        });
                        extension.getPublications().create("debug", MavenPublication.class, (Action)new Action<MavenPublication>(){

                            public void execute(MavenPublication publication) {
                                publication.setGroupId(project.getGroup().toString());
                                publication.setArtifactId((String)application.getBaseName().get() + "_debug");
                                publication.setVersion(project.getVersion().toString());
                                NativeRuntimeVariant debugVariant = new NativeRuntimeVariant("debug", (SoftwareComponent)mainVariant, runtimeUsage, (Set<? extends PublishArtifact>)debugRuntimeElements.getAllArtifacts(), debugRuntimeElements);
                                mainVariant.addVariant(debugVariant);
                                publication.from((SoftwareComponent)debugVariant);
                            }
                        });
                        extension.getPublications().create("release", MavenPublication.class, (Action)new Action<MavenPublication>(){

                            public void execute(MavenPublication publication) {
                                publication.setGroupId(project.getGroup().toString());
                                publication.setArtifactId((String)application.getBaseName().get() + "_release");
                                publication.setVersion(project.getVersion().toString());
                                NativeRuntimeVariant releaseVariant = new NativeRuntimeVariant("release", (SoftwareComponent)mainVariant, runtimeUsage, (Set<? extends PublishArtifact>)releaseRuntimeElements.getAllArtifacts(), releaseRuntimeElements);
                                mainVariant.addVariant(releaseVariant);
                                publication.from((SoftwareComponent)releaseVariant);
                            }
                        });
                    }
                });
            }
        });
    }
}

