/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.GradleException;
import org.gradle.cache.FileAccess;
import org.gradle.cache.PersistentStateCache;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InputStreamBackedDecoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.internal.serialize.Serializer;

public class SimpleStateCache<T>
implements PersistentStateCache<T> {
    private final FileAccess fileAccess;
    private final Serializer<T> serializer;
    private final Chmod chmod;
    private final File cacheFile;

    public SimpleStateCache(File cacheFile, FileAccess fileAccess, Serializer<T> serializer, Chmod chmod) {
        this.cacheFile = cacheFile;
        this.fileAccess = fileAccess;
        this.serializer = serializer;
        this.chmod = chmod;
    }

    @Override
    public T get() {
        return this.fileAccess.readFile(new Factory<T>(){

            public T create() {
                return SimpleStateCache.this.deserialize();
            }
        });
    }

    @Override
    public void set(final T newValue) {
        this.fileAccess.writeFile(new Runnable(){

            @Override
            public void run() {
                SimpleStateCache.this.serialize(newValue);
            }
        });
    }

    @Override
    public T update(PersistentStateCache.UpdateAction<T> updateAction) {
        class Updater
        implements Runnable {
            private final PersistentStateCache.UpdateAction<T> updateAction;
            private T result;

            Updater(PersistentStateCache.UpdateAction<T> updateAction) {
                this.updateAction = updateAction;
            }

            @Override
            public void run() {
                Object oldValue = SimpleStateCache.this.deserialize();
                this.result = this.updateAction.update(oldValue);
                SimpleStateCache.this.serialize(this.result);
            }
        }
        Updater updater = new Updater(updateAction);
        this.fileAccess.updateFile(updater);
        return (T)updater.result;
    }

    @Override
    public T maybeUpdate(PersistentStateCache.UpdateAction<T> updateAction) {
        class MaybeUpdater
        implements Runnable {
            private final PersistentStateCache.UpdateAction<T> updateAction;
            private T result;

            MaybeUpdater(PersistentStateCache.UpdateAction<T> updateAction) {
                this.updateAction = updateAction;
            }

            @Override
            public void run() {
                Object oldValue = SimpleStateCache.this.deserialize();
                this.result = this.updateAction.update(oldValue);
                if (oldValue != this.result) {
                    SimpleStateCache.this.serialize(this.result);
                }
            }
        }
        MaybeUpdater maybeUpdater = new MaybeUpdater(updateAction);
        this.fileAccess.updateFile(maybeUpdater);
        return (T)maybeUpdater.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(T newValue) {
        try {
            if (!this.cacheFile.isFile()) {
                this.cacheFile.createNewFile();
            }
            this.chmod.chmod(this.cacheFile.getParentFile(), 448);
            this.chmod.chmod(this.cacheFile, 384);
            try (OutputStreamBackedEncoder encoder = new OutputStreamBackedEncoder((OutputStream)new BufferedOutputStream(new FileOutputStream(this.cacheFile)));){
                this.serializer.write((Encoder)encoder, newValue);
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not write cache value to '%s'.", this.cacheFile), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T deserialize() {
        if (!this.cacheFile.isFile()) {
            return null;
        }
        try (InputStreamBackedDecoder decoder = new InputStreamBackedDecoder((InputStream)new BufferedInputStream(new FileInputStream(this.cacheFile)));){
            Object object = this.serializer.read((Decoder)decoder);
            return (T)object;
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not read cache value from '%s'.", this.cacheFile), (Throwable)e);
        }
    }
}

