/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.Internal;
import org.gradle.ide.visualstudio.TextProvider;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.VisualStudioSolution;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioSolution;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.tasks.internal.VisualStudioSolutionFile;
import org.gradle.plugins.ide.api.GeneratorTask;
import org.gradle.plugins.ide.internal.generator.generator.PersistableConfigurationObjectGenerator;

@Incubating
public class GenerateSolutionFileTask
extends GeneratorTask<VisualStudioSolutionFile> {
    private DefaultVisualStudioSolution solution;

    public GenerateSolutionFileTask() {
        this.generator = new ConfigurationObjectGenerator();
    }

    public void setVisualStudioSolution(VisualStudioSolution solution) {
        this.solution = (DefaultVisualStudioSolution)solution;
        this.dependsOn(new Object[]{new Callable<Set<VisualStudioProject>>(){

            @Override
            public Set<VisualStudioProject> call() throws Exception {
                return GenerateSolutionFileTask.this.solution.getProjects();
            }
        }});
    }

    @Internal
    public VisualStudioSolution getSolution() {
        return this.solution;
    }

    public File getInputFile() {
        return null;
    }

    public File getOutputFile() {
        return this.solution.getSolutionFile().getLocation();
    }

    private class ConfigurationObjectGenerator
    extends PersistableConfigurationObjectGenerator<VisualStudioSolutionFile> {
        private ConfigurationObjectGenerator() {
        }

        public VisualStudioSolutionFile create() {
            return new VisualStudioSolutionFile();
        }

        public void configure(VisualStudioSolutionFile solutionFile) {
            DefaultVisualStudioSolution solution = (DefaultVisualStudioSolution)GenerateSolutionFileTask.this.getSolution();
            solutionFile.setMainProject(solution.getRootProject());
            for (VisualStudioProjectConfiguration visualStudioProjectConfiguration : solution.getSolutionConfigurations()) {
                solutionFile.addSolutionConfiguration(visualStudioProjectConfiguration.getName(), solution.getProjectConfigurations(visualStudioProjectConfiguration));
            }
            for (Action action : solution.getSolutionFile().getTextActions()) {
                solutionFile.getActions().add((Action<? super TextProvider>)action);
            }
        }
    }
}

