/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationTargetUtil;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiCatchSection;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceVariable;
import org.jetbrains.kotlin.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.ModifierFlags;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiExtensibleClass;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.WeakInterner;
import org.jetbrains.kotlin.gnu.trove.THashMap;

public class PsiModifierListImpl
extends JavaStubPsiElement<PsiModifierListStub>
implements PsiModifierList {
    private static final Map<String, IElementType> NAME_TO_KEYWORD_TYPE_MAP = new THashMap<String, IElementType>();
    private static final Map<IElementType, String> KEYWORD_TYPE_TO_NAME_MAP;
    private volatile ModifierCache myModifierCache;

    public PsiModifierListImpl(PsiModifierListStub stub) {
        super(stub, JavaStubElementTypes.MODIFIER_LIST);
    }

    public PsiModifierListImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl", "hasModifierProperty"));
        }
        ModifierCache modifierCache = this.myModifierCache;
        if (modifierCache == null || !modifierCache.isUpToDate()) {
            this.myModifierCache = modifierCache = this.calcModifiers();
        }
        return modifierCache.modifiers.contains(name);
    }

    private ModifierCache calcModifiers() {
        Set<String> modifiers2 = this.calcExplicitModifiers();
        modifiers2.addAll(this.calcImplicitModifiers(modifiers2));
        if (!(modifiers2.contains("public") || modifiers2.contains("protected") || modifiers2.contains("private"))) {
            modifiers2.add("packageLocal");
        }
        PsiFile file = this.getContainingFile();
        return new ModifierCache(file, PsiAugmentProvider.transformModifierProperties(this, file.getProject(), modifiers2));
    }

    private Set<String> calcExplicitModifiers() {
        HashSet<String> explicitModifiers = ContainerUtil.newHashSet();
        PsiModifierListStub stub = (PsiModifierListStub)this.getGreenStub();
        if (stub != null) {
            int mask = stub.getModifiersMask();
            for (int i = 0; i < 31; ++i) {
                int flag = 1 << i;
                if (!BitUtil.isSet(mask, flag)) continue;
                ContainerUtil.addIfNotNull(explicitModifiers, ModifierFlags.MODIFIER_FLAG_TO_NAME_MAP.get(flag));
            }
        } else {
            for (ASTNode child : this.getNode().getChildren(null)) {
                ContainerUtil.addIfNotNull(explicitModifiers, KEYWORD_TYPE_TO_NAME_MAP.get(child.getElementType()));
            }
        }
        return explicitModifiers;
    }

    private Set<String> calcImplicitModifiers(Set<String> explicitModifiers) {
        HashSet<String> implicitModifiers = ContainerUtil.newHashSet();
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof PsiClass) {
            PsiElement grandParent = parent2.getContext();
            if (grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface()) {
                Collections.addAll(implicitModifiers, "public", "static");
            }
            if (((PsiClass)parent2).isInterface()) {
                implicitModifiers.add("abstract");
                if (grandParent instanceof PsiClass) {
                    implicitModifiers.add("static");
                }
            }
            if (((PsiClass)parent2).isEnum()) {
                boolean hasSubClass;
                if (!(grandParent instanceof PsiFile)) {
                    implicitModifiers.add("static");
                }
                List<PsiField> fields2 = parent2 instanceof PsiExtensibleClass ? ((PsiExtensibleClass)parent2).getOwnFields() : Arrays.asList(((PsiClass)parent2).getFields());
                boolean bl = hasSubClass = ContainerUtil.find(fields2, field -> field instanceof PsiEnumConstant && ((PsiEnumConstant)field).getInitializingClass() != null) != null;
                if (!hasSubClass) {
                    implicitModifiers.add("final");
                }
                List<PsiMethod> methods2 = parent2 instanceof PsiExtensibleClass ? ((PsiExtensibleClass)parent2).getOwnMethods() : Arrays.asList(((PsiClass)parent2).getMethods());
                for (PsiMethod method : methods2) {
                    if (!method.hasModifierProperty("abstract")) continue;
                    implicitModifiers.add("abstract");
                    break;
                }
            }
        } else if (parent2 instanceof PsiMethod) {
            PsiClass aClass2 = ((PsiMethod)parent2).getContainingClass();
            if (aClass2 != null && aClass2.isInterface()) {
                if (!explicitModifiers.contains("private")) {
                    implicitModifiers.add("public");
                    if (!explicitModifiers.contains("default") && !explicitModifiers.contains("static")) {
                        implicitModifiers.add("abstract");
                    }
                }
            } else if (aClass2 != null && aClass2.isEnum() && ((PsiMethod)parent2).isConstructor()) {
                implicitModifiers.add("private");
            }
        } else if (parent2 instanceof PsiField) {
            if (parent2 instanceof PsiEnumConstant) {
                Collections.addAll(implicitModifiers, "public", "static", "final");
            } else {
                PsiClass aClass3 = ((PsiField)parent2).getContainingClass();
                if (aClass3 != null && aClass3.isInterface()) {
                    Collections.addAll(implicitModifiers, "public", "static", "final");
                }
            }
        } else if (parent2 instanceof PsiParameter && parent2.getParent() instanceof PsiCatchSection && ((PsiParameter)parent2).getType() instanceof PsiDisjunctionType) {
            Collections.addAll(implicitModifiers, "final");
        } else if (parent2 instanceof PsiResourceVariable) {
            Collections.addAll(implicitModifiers, "final");
        }
        return implicitModifiers;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        IElementType type2;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl", "hasExplicitModifier"));
        }
        PsiModifierListStub stub = (PsiModifierListStub)this.getGreenStub();
        if (stub != null) {
            return BitUtil.isSet(stub.getModifiersMask(), ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.get(name));
        }
        CompositeElement tree = (CompositeElement)this.getNode();
        return tree.findChildByType(type2 = NAME_TO_KEYWORD_TYPE_MAP.get(name)) != null;
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl", "setModifierProperty"));
        }
        this.checkSetModifierProperty(name, value);
        PsiElement parent2 = this.getParent();
        PsiElement grandParent = parent2 != null ? parent2.getParent() : null;
        IElementType type2 = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        CompositeElement treeElement = (CompositeElement)this.getNode();
        if (parent2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent2;
            CodeEditUtil.markToReformat(method.getParameterList().getNode(), true);
        }
        if (value) {
            if (type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.PRIVATE_KEYWORD || type2 == JavaTokenType.PROTECTED_KEYWORD || type2 == null) {
                if (type2 != JavaTokenType.PUBLIC_KEYWORD) {
                    this.setModifierProperty("public", false);
                }
                if (type2 != JavaTokenType.PRIVATE_KEYWORD) {
                    this.setModifierProperty("private", false);
                }
                if (type2 != JavaTokenType.PROTECTED_KEYWORD) {
                    this.setModifierProperty("protected", false);
                }
                if (type2 == null) {
                    return;
                }
            }
            if (parent2 instanceof PsiField && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.STATIC_KEYWORD || type2 == JavaTokenType.FINAL_KEYWORD : (parent2 instanceof PsiMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.ABSTRACT_KEYWORD : (parent2 instanceof PsiClass && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type2 == JavaTokenType.PUBLIC_KEYWORD : parent2 instanceof PsiAnnotationMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isAnnotationType() && (type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.ABSTRACT_KEYWORD)))) {
                return;
            }
            if (treeElement.findChildByType(type2) == null) {
                LeafElement keyword = Factory.createSingleLeafElement(type2, name, null, this.getManager());
                treeElement.addInternal(keyword, keyword, null, null);
            }
        } else {
            if (type2 == null) {
                throw new IncorrectOperationException("Cannot reset package-private modifier.");
            }
            ASTNode child = treeElement.findChildByType(type2);
            if (child != null) {
                SourceTreeToPsiMap.treeToPsiNotNull(child).delete();
            }
        }
    }

    @Override
    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl", "checkSetModifierProperty"));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] own = (PsiAnnotation[])this.getStubOrPsiChildren(JavaStubElementTypes.ANNOTATION, PsiAnnotation.ARRAY_FACTORY);
        List<PsiAnnotation> ext = PsiAugmentProvider.collectAugments(this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = ArrayUtil.mergeArrayAndCollection(own, ext, PsiAnnotation.ARRAY_FACTORY);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation(this);
        List<PsiAnnotation> filtered = ContainerUtil.findAll(this.getAnnotations(), annotation2 -> {
            PsiAnnotation.TargetType target = AnnotationTargetUtil.findAnnotationTarget(annotation2, targets);
            return target != null && target != PsiAnnotation.TargetType.UNKNOWN;
        });
        PsiAnnotation[] psiAnnotationArray = filtered.toArray(new PsiAnnotation[filtered.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName2) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl", "findAnnotation"));
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName2);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName2) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl", "addAnnotation"));
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addAfter(JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createAnnotationFromText("@" + qualifiedName2, this), null);
        if (psiAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl", "addAnnotation"));
        }
        return psiAnnotation;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModifierList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiModifierList:" + this.getText();
    }

    static {
        NAME_TO_KEYWORD_TYPE_MAP.put("public", JavaTokenType.PUBLIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("protected", JavaTokenType.PROTECTED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("private", JavaTokenType.PRIVATE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("static", JavaTokenType.STATIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("abstract", JavaTokenType.ABSTRACT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("final", JavaTokenType.FINAL_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("native", JavaTokenType.NATIVE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("synchronized", JavaTokenType.SYNCHRONIZED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("strictfp", JavaTokenType.STRICTFP_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transient", JavaTokenType.TRANSIENT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("volatile", JavaTokenType.VOLATILE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("default", JavaTokenType.DEFAULT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("open", JavaTokenType.OPEN_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transitive", JavaTokenType.TRANSITIVE_KEYWORD);
        KEYWORD_TYPE_TO_NAME_MAP = ContainerUtil.newTroveMap();
        for (String name : NAME_TO_KEYWORD_TYPE_MAP.keySet()) {
            KEYWORD_TYPE_TO_NAME_MAP.put(NAME_TO_KEYWORD_TYPE_MAP.get(name), name);
        }
    }

    private static class ModifierCache {
        static final WeakInterner<List<String>> ourInterner = new WeakInterner();
        final PsiFile file;
        final List<String> modifiers;
        final long modCount;

        ModifierCache(@NotNull PsiFile file, @NotNull Set<String> modifiers2) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl$ModifierCache", "<init>"));
            }
            if (modifiers2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiModifierListImpl$ModifierCache", "<init>"));
            }
            this.file = file;
            ArrayList<String> modifierList = ContainerUtil.newArrayList(modifiers2);
            Collections.sort(modifierList);
            this.modifiers = ourInterner.intern(modifierList);
            this.modCount = this.getModCount();
        }

        private long getModCount() {
            return this.file.getManager().getModificationTracker().getModificationCount() + this.file.getModificationStamp();
        }

        boolean isUpToDate() {
            return this.getModCount() == this.modCount;
        }
    }
}

