/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.presentation.java;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.navigation.ColoredItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.openapi.editor.colors.CodeInsightColors;
import org.jetbrains.kotlin.com.intellij.openapi.editor.colors.TextAttributesKey;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.psi.PsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

public class JavaPresentationUtil {
    private JavaPresentationUtil() {
    }

    @NotNull
    public static ColoredItemPresentation getMethodPresentation(final @NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/kotlin/com/intellij/psi/presentation/java/JavaPresentationUtil", "getMethodPresentation"));
        }
        ColoredItemPresentation coloredItemPresentation = new ColoredItemPresentation(){

            public String getPresentableText() {
                return PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 257, 2);
            }

            public TextAttributesKey getTextAttributesKey() {
                try {
                    if (psiMethod.isDeprecated()) {
                        return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return null;
            }

            public String getLocationString() {
                return JavaPresentationUtil.getJavaSymbolContainerText(psiMethod);
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiMethod.getIcon(1);
            }
        };
        if (coloredItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/presentation/java/JavaPresentationUtil", "getMethodPresentation"));
        }
        return coloredItemPresentation;
    }

    @NotNull
    public static ItemPresentation getFieldPresentation(final @NotNull PsiField psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "org/jetbrains/kotlin/com/intellij/psi/presentation/java/JavaPresentationUtil", "getFieldPresentation"));
        }
        ColoredItemPresentation coloredItemPresentation = new ColoredItemPresentation(){

            public String getPresentableText() {
                return psiField.getName();
            }

            public TextAttributesKey getTextAttributesKey() {
                try {
                    if (psiField.isDeprecated()) {
                        return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return null;
            }

            public String getLocationString() {
                return JavaPresentationUtil.getJavaSymbolContainerText(psiField);
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiField.getIcon(1);
            }
        };
        if (coloredItemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/presentation/java/JavaPresentationUtil", "getFieldPresentation"));
        }
        return coloredItemPresentation;
    }

    @Nullable
    private static String getJavaSymbolContainerText(@NotNull PsiElement element) {
        String qName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/presentation/java/JavaPresentationUtil", "getJavaSymbolContainerText"));
        }
        Object container2 = PsiTreeUtil.getParentOfType(element, PsiMember.class, PsiFile.class);
        String result2 = container2 instanceof PsiClass ? ((qName = ((PsiClass)container2).getQualifiedName()) != null ? qName : ((PsiClass)container2).getName()) : (container2 instanceof PsiJavaFile ? ((PsiJavaFile)container2).getPackageName() : null);
        if (result2 != null) {
            return PsiBundle.message("aux.context.display", result2);
        }
        return null;
    }
}

