/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import com.google.common.base.Objects;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.SetSerializer;

public class ClassAnalysisSerializer
extends AbstractSerializer<ClassAnalysis> {
    private SetSerializer<String> stringSetSerializer = new SetSerializer(BaseSerializerFactory.STRING_SERIALIZER, false);
    private SetSerializer<Integer> integerSetSerializer = new SetSerializer(BaseSerializerFactory.INTEGER_SERIALIZER, false);

    public ClassAnalysis read(Decoder decoder) throws Exception {
        String className = decoder.readString();
        boolean relatedToAll = decoder.readBoolean();
        Set classes = (Set)this.stringSetSerializer.read(decoder);
        Set constants = (Set)this.integerSetSerializer.read(decoder);
        Set literals = (Set)this.integerSetSerializer.read(decoder);
        Set superTypes = (Set)this.stringSetSerializer.read(decoder);
        return new ClassAnalysis(className, classes, relatedToAll, constants, literals, superTypes);
    }

    public void write(Encoder encoder, ClassAnalysis value) throws Exception {
        encoder.writeString((CharSequence)value.getClassName());
        encoder.writeBoolean(value.isDependencyToAll());
        this.stringSetSerializer.write(encoder, value.getClassDependencies());
        this.integerSetSerializer.write(encoder, value.getConstants());
        this.integerSetSerializer.write(encoder, value.getLiterals());
        this.stringSetSerializer.write(encoder, value.getSuperTypes());
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ClassAnalysisSerializer rhs = (ClassAnalysisSerializer)((Object)obj);
        return Objects.equal(this.stringSetSerializer, rhs.stringSetSerializer) && Objects.equal(this.integerSetSerializer, rhs.integerSetSerializer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.stringSetSerializer, this.integerSetSerializer});
    }
}

