/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.groovy.scripts.internal.AbstractScriptTransformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.StatementTransformer;
import org.gradle.internal.UncheckedException;

public class SubsetScriptTransformer
extends AbstractScriptTransformer {
    private final StatementTransformer transformer;

    public SubsetScriptTransformer(StatementTransformer transformer) {
        this.transformer = transformer;
    }

    protected int getPhase() {
        return 3;
    }

    public void call(SourceUnit source) throws CompilationFailedException {
        ImportNode importedClass2;
        AstUtils.filterAndTransformStatements((SourceUnit)source, (StatementTransformer)this.transformer);
        for (ImportNode importedClass2 : source.getAST().getImports()) {
            if (AstUtils.isVisible((SourceUnit)source, (String)importedClass2.getClassName())) continue;
            try {
                Field field = ModuleNode.class.getDeclaredField("imports");
                field.setAccessible(true);
                Map value = (Map)field.get(source.getAST());
                value.remove(importedClass2.getAlias());
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        Iterator<Object> iter = source.getAST().getStaticImports().values().iterator();
        while (iter.hasNext()) {
            importedClass2 = (ImportNode)iter.next();
            if (AstUtils.isVisible((SourceUnit)source, (String)importedClass2.getClassName())) continue;
            iter.remove();
        }
        iter = source.getAST().getStaticStarImports().values().iterator();
        while (iter.hasNext()) {
            importedClass2 = (ImportNode)iter.next();
            if (AstUtils.isVisible((SourceUnit)source, (String)importedClass2.getClassName())) continue;
            iter.remove();
        }
        ClassNode scriptClass = AstUtils.getScriptClass((SourceUnit)source);
        Iterator classes = source.getAST().getClasses().iterator();
        while (classes.hasNext()) {
            ClassNode classNode = (ClassNode)classes.next();
            if (classNode == scriptClass) continue;
            classes.remove();
        }
        if (scriptClass != null) {
            for (MethodNode methodNode : new ArrayList(scriptClass.getMethods())) {
                if (methodNode.getName().equals("run")) continue;
                AstUtils.removeMethod((ClassNode)scriptClass, (MethodNode)methodNode);
            }
        }
        source.getAST().getMethods().clear();
    }
}

