/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.EnabledOnlyBooleanBuildOption;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLayoutParametersBuildOptions {
    private static List<BuildOption<BuildLayoutParameters>> options;

    public static List<BuildOption<BuildLayoutParameters>> get() {
        return options;
    }

    private BuildLayoutParametersBuildOptions() {
    }

    static {
        ArrayList<Object> options = new ArrayList<Object>();
        options.add((Object)new GradleUserHomeOption());
        options.add((Object)new ProjectDirOption());
        options.add((Object)new NoSearchUpwardsOption());
        BuildLayoutParametersBuildOptions.options = Collections.unmodifiableList(options);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NoSearchUpwardsOption
    extends EnabledOnlyBooleanBuildOption<BuildLayoutParameters> {
        public NoSearchUpwardsOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"no-search-upward", (String)"u", (String)"Don't search in parent folders for a settings file.")});
        }

        public void applyTo(BuildLayoutParameters settings, Origin origin) {
            settings.setSearchUpwards(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectDirOption
    extends StringBuildOption<BuildLayoutParameters> {
        public ProjectDirOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"project-dir", (String)"p", (String)"Specifies the start directory for Gradle. Defaults to current directory.")});
        }

        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setProjectDir((File)resolver.transform(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GradleUserHomeOption
    extends StringBuildOption<BuildLayoutParameters> {
        public GradleUserHomeOption() {
            super("gradle.user.home", new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"gradle-user-home", (String)"g", (String)"Specifies the gradle user home directory.")});
        }

        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setGradleUserHomeDir((File)resolver.transform(value));
        }
    }
}

