/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutConfiguration;
import org.gradle.internal.FileUtils;
import org.gradle.internal.scripts.DefaultScriptFileResolver;
import org.gradle.internal.scripts.ScriptFileResolver;

public class BuildLayoutFactory {
    private static final String DEFAULT_SETTINGS_FILE_BASENAME = "settings";
    private final ScriptFileResolver scriptFileResolver;

    public static BuildLayoutFactory forDefaultScriptingLanguages() {
        return new BuildLayoutFactory();
    }

    public BuildLayoutFactory(ScriptFileResolver scriptFileResolver) {
        this.scriptFileResolver = scriptFileResolver;
    }

    @Deprecated
    public BuildLayoutFactory() {
        this(DefaultScriptFileResolver.forDefaultScriptingLanguages());
    }

    public BuildLayout getLayoutFor(File currentDir, boolean searchUpwards) {
        return this.getLayoutFor(currentDir, searchUpwards ? null : currentDir.getParentFile());
    }

    public BuildLayout getLayoutFor(BuildLayoutConfiguration configuration) {
        if (configuration.isUseEmptySettings()) {
            return this.buildLayoutFrom(configuration, null);
        }
        File explicitSettingsFile = configuration.getSettingsFile();
        if (explicitSettingsFile != null) {
            if (!explicitSettingsFile.isFile()) {
                throw new MissingResourceException(explicitSettingsFile.toURI(), String.format("Could not read settings file '%s' as it does not exist.", explicitSettingsFile.getAbsolutePath()));
            }
            return this.buildLayoutFrom(configuration, explicitSettingsFile);
        }
        File currentDir = configuration.getCurrentDir();
        boolean searchUpwards = configuration.isSearchUpwards();
        return this.getLayoutFor(currentDir, searchUpwards ? null : currentDir.getParentFile());
    }

    private BuildLayout buildLayoutFrom(BuildLayoutConfiguration configuration, File settingsFile) {
        return new BuildLayout(configuration.getCurrentDir(), configuration.getCurrentDir(), settingsFile);
    }

    @Nullable
    public File findExistingSettingsFileIn(File directory) {
        File defaultSettingsFile = new File(directory, "settings.gradle");
        return defaultSettingsFile.isFile() ? defaultSettingsFile : this.scriptFileResolver.resolveScriptFile(directory, DEFAULT_SETTINGS_FILE_BASENAME);
    }

    BuildLayout getLayoutFor(File currentDir, File stopAt) {
        File settingsFile = this.findExistingSettingsFileIn(currentDir);
        if (settingsFile != null) {
            return this.layout(currentDir, settingsFile);
        }
        for (File candidate = currentDir.getParentFile(); candidate != null && !candidate.equals(stopAt); candidate = candidate.getParentFile()) {
            settingsFile = this.findExistingSettingsFileIn(candidate);
            if (settingsFile == null) {
                settingsFile = this.findExistingSettingsFileIn(new File(candidate, "master"));
            }
            if (settingsFile == null) continue;
            return this.layout(candidate, settingsFile);
        }
        return this.layout(currentDir, new File(currentDir, "settings.gradle"));
    }

    private BuildLayout layout(File rootDir, File settingsFile) {
        return new BuildLayout(rootDir, settingsFile.getParentFile(), FileUtils.canonicalize((File)settingsFile));
    }
}

