/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultMutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSource;

public class DefaultMavenModuleResolveMetadata
extends AbstractModuleComponentResolveMetadata
implements MavenModuleResolveMetadata {
    public static final String POM_PACKAGING = "pom";
    public static final Collection<String> JAR_PACKAGINGS = Arrays.asList("jar", "ejb", "bundle", "maven-plugin", "eclipse-plugin");
    private static final PreferJavaRuntimeVariant SCHEMA_DEFAULT_JAVA_VARIANTS = new PreferJavaRuntimeVariant();
    private final String packaging;
    private final boolean relocated;
    private final String snapshotTimestamp;
    private final ImmutableList<? extends ComponentVariant> variants;
    private final ImmutableList<? extends ConfigurationMetadata> graphVariants;

    DefaultMavenModuleResolveMetadata(MutableMavenModuleResolveMetadata metadata) {
        super(metadata);
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
        this.variants = metadata.getVariants();
        this.graphVariants = metadata.getVariantsForGraphTraversal();
    }

    private DefaultMavenModuleResolveMetadata(DefaultMavenModuleResolveMetadata metadata, ModuleSource source) {
        super(metadata, source);
        this.packaging = metadata.packaging;
        this.relocated = metadata.relocated;
        this.snapshotTimestamp = metadata.snapshotTimestamp;
        this.variants = metadata.variants;
        this.graphVariants = metadata.graphVariants;
    }

    @Override
    public DefaultMavenModuleResolveMetadata withSource(ModuleSource source) {
        return new DefaultMavenModuleResolveMetadata(this, source);
    }

    @Override
    public MutableMavenModuleResolveMetadata asMutable() {
        return new DefaultMutableMavenModuleResolveMetadata(this);
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public boolean isPomPackaging() {
        return POM_PACKAGING.equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return JAR_PACKAGINGS.contains(this.packaging);
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public ImmutableList<? extends ConfigurationMetadata> getVariantsForGraphTraversal() {
        return this.graphVariants;
    }

    @Override
    public ImmutableList<? extends ComponentVariant> getVariants() {
        return this.variants;
    }

    @Override
    @Nullable
    public AttributesSchemaInternal getAttributesSchema() {
        return SCHEMA_DEFAULT_JAVA_VARIANTS;
    }

    private static class PreferJavaRuntimeVariant
    extends EmptySchema {
        private static final NamedObjectInstantiator INSTANTIATOR = NamedObjectInstantiator.INSTANCE;
        private static final Usage JAVA_API = (Usage)INSTANTIATOR.named(Usage.class, "java-api");
        private static final Usage JAVA_RUNTIME = (Usage)INSTANTIATOR.named(Usage.class, "java-runtime");
        private static final Set<Usage> DEFAULT_JAVA_USAGES = ImmutableSet.of((Object)JAVA_API, (Object)JAVA_RUNTIME);

        private PreferJavaRuntimeVariant() {
        }

        @Override
        public DisambiguationRule<Object> disambiguationRules(Attribute<?> attribute) {
            if (attribute.getType().equals(Usage.class)) {
                return (DisambiguationRule)Cast.uncheckedCast((Object)new DisambiguationRule<Usage>(){

                    public void execute(MultipleCandidatesResult<Usage> details) {
                        if (details.getConsumerValue() == null && details.getCandidateValues().equals(DEFAULT_JAVA_USAGES)) {
                            details.closestMatch(JAVA_RUNTIME);
                        }
                    }
                });
            }
            return super.disambiguationRules(attribute);
        }
    }
}

