/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ArgumentAndDeclIndex;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.ValueKind;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.org.objectweb.asm.Type;

public class CallBasedArgumentGenerator
extends ArgumentGenerator {
    private final ExpressionCodegen codegen;
    private final CallGenerator callGenerator;
    private final List<ValueParameterDescriptor> valueParameters;
    private final List<Type> valueParameterTypes;

    public CallBasedArgumentGenerator(@NotNull ExpressionCodegen codegen, @NotNull CallGenerator callGenerator, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<Type> valueParameterTypes) {
        if (codegen == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(0);
        }
        if (callGenerator == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(1);
        }
        if (valueParameters == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(2);
        }
        if (valueParameterTypes == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(3);
        }
        this.codegen = codegen;
        this.callGenerator = callGenerator;
        this.valueParameters = valueParameters;
        this.valueParameterTypes = valueParameterTypes;
        assert (valueParameters.size() == valueParameterTypes.size()) : "Value parameters and their types mismatch in sizes: " + valueParameters.size() + " != " + valueParameterTypes.size();
    }

    @Override
    protected void generateExpression(int i, @NotNull ExpressionValueArgument argument) {
        if (argument == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(4);
        }
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        Type type2 = this.valueParameterTypes.get(i);
        ValueArgument valueArgument = argument.getValueArgument();
        assert (valueArgument != null);
        KtExpression argumentExpression = valueArgument.getArgumentExpression();
        assert (argumentExpression != null) : valueArgument.asElement().getText();
        this.callGenerator.genValueAndPut(parameter, argumentExpression, type2, i);
    }

    @Override
    protected void generateDefault(int i, @NotNull DefaultValueArgument argument) {
        if (argument == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(5);
        }
        this.callGenerator.putValueIfNeeded(this.valueParameterTypes.get(i), StackValue.createDefaultValue(this.valueParameterTypes.get(i)), ValueKind.DEFAULT_PARAMETER, i);
    }

    @Override
    protected void generateVararg(int i, @NotNull VarargValueArgument argument) {
        if (argument == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(6);
        }
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        StackValue lazyVararg = this.codegen.genVarargs(argument, FlexibleTypesKt.upperIfFlexible(parameter.getType()));
        this.callGenerator.putValueIfNeeded(this.valueParameterTypes.get(i), lazyVararg, ValueKind.GENERAL_VARARG, i);
    }

    @Override
    protected void reorderArgumentsIfNeeded(@NotNull List<ArgumentAndDeclIndex> actualArgsWithDeclIndex) {
        if (actualArgsWithDeclIndex == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(7);
        }
        this.callGenerator.reorderArgumentsIfNeeded(actualArgsWithDeclIndex, this.valueParameterTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameterTypes";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualArgsWithDeclIndex";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "generateExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "generateDefault";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "generateVararg";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "reorderArgumentsIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

