/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class LocalFileDependencyBackedArtifactSet
implements ResolvedArtifactSet {
    private final LocalFileDependencyMetadata dependencyMetadata;
    private final Spec<? super ComponentIdentifier> componentFilter;
    private final VariantSelector selector;
    private final ArtifactTypeRegistry artifactTypeRegistry;

    public LocalFileDependencyBackedArtifactSet(LocalFileDependencyMetadata dependencyMetadata, Spec<? super ComponentIdentifier> componentFilter, VariantSelector selector, ArtifactTypeRegistry artifactTypeRegistry) {
        this.dependencyMetadata = dependencyMetadata;
        this.componentFilter = componentFilter;
        this.selector = selector;
        this.artifactTypeRegistry = artifactTypeRegistry;
    }

    @Override
    public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
        Set files;
        if (!listener.includeFileDependencies()) {
            return EMPTY_RESULT;
        }
        ComponentIdentifier componentIdentifier = this.dependencyMetadata.getComponentId();
        if (componentIdentifier != null && !this.componentFilter.isSatisfiedBy((Object)componentIdentifier)) {
            return EMPTY_RESULT;
        }
        try {
            files = this.dependencyMetadata.getFiles().getFiles();
        }
        catch (Throwable throwable) {
            return new BrokenResolvedArtifactSet(throwable);
        }
        ArrayList selectedArtifacts = Lists.newArrayListWithCapacity((int)files.size());
        for (File file : files) {
            Object artifactIdentifier;
            if (componentIdentifier == null) {
                artifactIdentifier = new OpaqueComponentArtifactIdentifier(file);
                if (!this.componentFilter.isSatisfiedBy((Object)artifactIdentifier.getComponentIdentifier())) {
                    continue;
                }
            } else {
                artifactIdentifier = new ComponentFileArtifactIdentifier(componentIdentifier, file.getName());
            }
            ImmutableAttributes variantAttributes = this.artifactTypeRegistry.mapAttributesFor(file);
            SingletonFileResolvedVariant variant = new SingletonFileResolvedVariant(file, (ComponentArtifactIdentifier)artifactIdentifier, "local file", (AttributeContainerInternal)variantAttributes, this.dependencyMetadata);
            selectedArtifacts.add(this.selector.select(variant));
        }
        return CompositeResolvedArtifactSet.of(selectedArtifacts).startVisit(actions, listener);
    }

    @Override
    public void collectBuildDependencies(BuildDependenciesVisitor visitor) {
        visitor.visitDependency(this.dependencyMetadata.getFiles().getBuildDependencies());
    }

    private static class SingletonFileResolvedVariant
    implements ResolvedVariant,
    ResolvedArtifactSet,
    ResolvedArtifactSet.Completion,
    ResolvedVariantSet {
        private final File file;
        private final ComponentArtifactIdentifier artifactIdentifier;
        private final String variantName;
        private final AttributeContainerInternal variantAttributes;
        private final LocalFileDependencyMetadata dependencyMetadata;

        SingletonFileResolvedVariant(File file, ComponentArtifactIdentifier artifactIdentifier, String variantName, AttributeContainerInternal variantAttributes, LocalFileDependencyMetadata dependencyMetadata) {
            this.file = file;
            this.artifactIdentifier = artifactIdentifier;
            this.variantName = variantName;
            this.variantAttributes = variantAttributes;
            this.dependencyMetadata = dependencyMetadata;
        }

        public String toString() {
            return this.asDescribable().getDisplayName();
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return this;
        }

        @Override
        public DisplayName asDescribable() {
            return Describables.of((Object)this.artifactIdentifier);
        }

        @Override
        public Set<ResolvedVariant> getVariants() {
            return Collections.singleton(this);
        }

        @Override
        public AttributesSchemaInternal getSchema() {
            return EmptySchema.INSTANCE;
        }

        @Override
        public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
            if (listener.includeFileDependencies()) {
                listener.fileAvailable(this.file);
                return this;
            }
            return EMPTY_RESULT;
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            visitor.visitFile(this.artifactIdentifier, this.variantName, (AttributeContainer)this.variantAttributes, this.file);
        }

        @Override
        public void collectBuildDependencies(BuildDependenciesVisitor visitor) {
            visitor.visitDependency(this.dependencyMetadata.getFiles().getBuildDependencies());
        }

        @Override
        public AttributeContainerInternal getAttributes() {
            return this.variantAttributes;
        }
    }
}

