/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.ModuleReplacementsData;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DefaultPendingDependenciesHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DirectDependencyForcingResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DownloadMetadataOperation;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.RejectedModuleMessageBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultCapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ModuleConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.ResolveContextToComponentResolver;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private final ModuleConflictHandler moduleConflictHandler;
    private final Spec<? super DependencyMetadata> edgeFilter;
    private final ResolveContextToComponentResolver moduleResolver;
    private final DependencyToComponentIdResolver idResolver;
    private final ComponentMetaDataResolver metaDataResolver;
    private final AttributesSchemaInternal attributesSchema;
    private final ModuleExclusions moduleExclusions;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ModuleReplacementsData moduleReplacementsData;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final DependencySubstitutionApplicator dependencySubstitutionApplicator;
    private final ImmutableAttributesFactory attributesFactory;
    private final CapabilitiesConflictHandler capabilitiesConflictHandler;

    public DependencyGraphBuilder(DependencyToComponentIdResolver componentIdResolver, ComponentMetaDataResolver componentMetaDataResolver, ResolveContextToComponentResolver resolveContextToComponentResolver, ModuleConflictHandler moduleConflictHandler, CapabilitiesConflictHandler capabilitiesConflictHandler, Spec<? super DependencyMetadata> edgeFilter, AttributesSchemaInternal attributesSchema, ModuleExclusions moduleExclusions, BuildOperationExecutor buildOperationExecutor, ModuleReplacementsData moduleReplacementsData, DependencySubstitutionApplicator dependencySubstitutionApplicator, ComponentSelectorConverter componentSelectorConverter, ImmutableAttributesFactory attributesFactory) {
        this.idResolver = componentIdResolver;
        this.metaDataResolver = componentMetaDataResolver;
        this.moduleResolver = resolveContextToComponentResolver;
        this.moduleConflictHandler = moduleConflictHandler;
        this.edgeFilter = edgeFilter;
        this.attributesSchema = attributesSchema;
        this.moduleExclusions = moduleExclusions;
        this.buildOperationExecutor = buildOperationExecutor;
        this.moduleReplacementsData = moduleReplacementsData;
        this.dependencySubstitutionApplicator = dependencySubstitutionApplicator;
        this.componentSelectorConverter = componentSelectorConverter;
        this.attributesFactory = attributesFactory;
        this.capabilitiesConflictHandler = capabilitiesConflictHandler;
    }

    public void resolve(ResolveContext resolveContext, DependencyGraphVisitor modelVisitor) {
        LongIdGenerator idGenerator = new LongIdGenerator();
        DefaultBuildableComponentResolveResult rootModule = new DefaultBuildableComponentResolveResult();
        this.moduleResolver.resolve(resolveContext, rootModule);
        ResolveState resolveState = new ResolveState((IdGenerator<Long>)idGenerator, rootModule, resolveContext.getName(), this.idResolver, this.metaDataResolver, this.edgeFilter, this.attributesSchema, this.moduleExclusions, this.moduleReplacementsData, this.componentSelectorConverter, this.attributesFactory, this.dependencySubstitutionApplicator);
        this.moduleConflictHandler.registerResolver(new DirectDependencyForcingResolver(resolveState.getRoot().getComponent()));
        this.traverseGraph(resolveState);
        this.validateGraph(resolveState);
        resolveState.getRoot().getComponent().setRoot();
        this.assembleResult(resolveState, modelVisitor);
    }

    private void traverseGraph(ResolveState resolveState) {
        resolveState.onMoreSelected(resolveState.getRoot());
        ArrayList dependencies = Lists.newArrayList();
        HashMap componentIdentifierCache = Maps.newHashMap();
        DefaultPendingDependenciesHandler pendingDependenciesHandler = new DefaultPendingDependenciesHandler();
        while (resolveState.peek() != null || this.moduleConflictHandler.hasConflicts() || this.capabilitiesConflictHandler.hasConflicts()) {
            if (resolveState.peek() != null) {
                NodeState node = resolveState.pop();
                LOGGER.debug("Visiting configuration {}.", (Object)node);
                this.registerCapabilities(resolveState, node.getComponent());
                dependencies.clear();
                node.visitOutgoingDependencies(dependencies, pendingDependenciesHandler);
                this.resolveEdges(node, dependencies, resolveState, componentIdentifierCache);
                continue;
            }
            if (this.moduleConflictHandler.hasConflicts()) {
                this.moduleConflictHandler.resolveNextConflict(resolveState.getReplaceSelectionWithConflictResultAction());
                continue;
            }
            this.capabilitiesConflictHandler.resolveNextConflict(resolveState.getReplaceSelectionWithConflictResultAction());
        }
    }

    private void registerCapabilities(final ResolveState resolveState, final ComponentState moduleRevision) {
        moduleRevision.forEachCapability((Action<? super Capability>)new Action<Capability>(){

            public void execute(Capability capability) {
                PotentialConflict c;
                Collection<ComponentState> implicitProvidersForCapability = Collections.emptyList();
                for (ModuleResolveState state : resolveState.getModules()) {
                    if (!state.getId().getGroup().equals(capability.getGroup()) || !state.getId().getName().equals(capability.getName())) continue;
                    implicitProvidersForCapability = state.getVersions();
                    break;
                }
                if ((c = DependencyGraphBuilder.this.capabilitiesConflictHandler.registerCandidate(DefaultCapabilitiesConflictHandler.candidate(moduleRevision, capability, implicitProvidersForCapability))).conflictExists()) {
                    c.withParticipatingModules(resolveState.getDeselectVersionAction());
                }
            }
        });
    }

    private void resolveEdges(NodeState node, List<EdgeState> dependencies, ResolveState resolveState, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        if (dependencies.isEmpty()) {
            return;
        }
        this.performSelectionSerially(dependencies, resolveState);
        this.maybeDownloadMetadataInParallel(node, componentIdentifierCache, dependencies);
        this.attachToTargetRevisionsSerially(dependencies);
    }

    private void performSelectionSerially(List<EdgeState> dependencies, ResolveState resolveState) {
        for (EdgeState dependency : dependencies) {
            assert (dependency.getTargetComponent() == null);
            SelectorState selector = dependency.getSelector();
            this.performSelection(resolveState, dependency, selector);
            selector.getTargetModule().addUnattachedDependency(dependency);
        }
    }

    private void performSelection(ResolveState resolveState, EdgeState dependency, SelectorState selector) {
        if (selector.selected != null) {
            dependency.start(selector.selected);
            return;
        }
        ComponentIdResolveResult idResolveResult = selector.resolve();
        if (idResolveResult.getFailure() != null) {
            return;
        }
        ComponentState candidate = resolveState.getRevision(idResolveResult.getId(), idResolveResult.getModuleVersionId(), idResolveResult.getMetadata());
        ModuleResolveState module = selector.getTargetModule();
        ComponentState currentSelection = module.getSelected();
        dependency.start(candidate);
        selector.select(candidate);
        if (currentSelection == null) {
            if (!this.moduleHasConflicts(resolveState, module)) {
                LOGGER.debug("Selecting new module {}", (Object)module.getId());
                module.select(candidate);
            }
            return;
        }
        ComponentState selected = this.chooseBest(module, selector, currentSelection, candidate);
        if (selected == currentSelection) {
            dependency.start(currentSelection);
            selector.select(currentSelection);
            this.maybeMarkRejected(currentSelection);
            return;
        }
        assert (selected == candidate);
        resolveState.getDeselectVersionAction().execute(module.getId());
        module.restart(candidate);
        this.maybeMarkRejected(candidate);
    }

    private ComponentState chooseBest(ModuleResolveState module, SelectorState selector, ComponentState currentSelection, final ComponentState candidate) {
        if (currentSelection == candidate) {
            return candidate;
        }
        if (DependencyGraphBuilder.selectorAgreesWith(selector, currentSelection.getVersion())) {
            return currentSelection;
        }
        if (DependencyGraphBuilder.allSelectorsAgreeWith(module.getSelectors(), candidate.getVersion(), new Predicate<SelectorState>(){

            public boolean apply(@Nullable SelectorState input) {
                return !candidate.getSelectedBy().contains(input);
            }
        })) {
            return candidate;
        }
        ImmutableList candidates = ImmutableList.of((Object)currentSelection, (Object)candidate);
        DefaultConflictResolverDetails details = new DefaultConflictResolverDetails(candidates);
        this.moduleConflictHandler.getResolver().select(details);
        if (details.hasFailure()) {
            throw UncheckedException.throwAsUncheckedException((Throwable)details.getFailure());
        }
        return (ComponentState)details.getSelected();
    }

    private boolean moduleHasConflicts(ResolveState resolveState, ModuleResolveState module) {
        PotentialConflict c = this.moduleConflictHandler.registerCandidate(module);
        if (c.conflictExists()) {
            LOGGER.debug("Found new conflicting module {}", (Object)module);
            c.withParticipatingModules(resolveState.getDeselectVersionAction());
            return true;
        }
        return false;
    }

    private void maybeMarkRejected(ComponentState selected) {
        if (selected.isRejected()) {
            return;
        }
        String version = selected.getVersion();
        ModuleResolveState moduleResolveState = selected.getModule();
        for (SelectorState selector : moduleResolveState.getSelectors()) {
            if (selector.getVersionConstraint() == null || selector.getVersionConstraint().getRejectedSelector() == null || !selector.getVersionConstraint().getRejectedSelector().accept(version)) continue;
            selected.reject();
            return;
        }
    }

    private void maybeDownloadMetadataInParallel(NodeState node, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache, List<EdgeState> dependencies) {
        List requiringDownload = null;
        for (EdgeState dependency : dependencies) {
            ComponentState targetComponent = dependency.getTargetComponent();
            if (targetComponent == null || !targetComponent.isSelected() || targetComponent.alreadyResolved() || this.metaDataResolver.isFetchingMetadataCheap(this.toComponentId(targetComponent.getId(), componentIdentifierCache))) continue;
            if (requiringDownload == null) {
                requiringDownload = Lists.newArrayList();
            }
            requiringDownload.add(dependency);
        }
        if (requiringDownload != null && requiringDownload.size() > 1) {
            final ImmutableList toDownloadInParallel = ImmutableList.copyOf((Collection)requiringDownload);
            LOGGER.debug("Submitting {} metadata files to resolve in parallel for {}", (Object)toDownloadInParallel.size(), (Object)node);
            this.buildOperationExecutor.runAll((Action)new Action<BuildOperationQueue<RunnableBuildOperation>>(){

                public void execute(BuildOperationQueue<RunnableBuildOperation> buildOperationQueue) {
                    for (EdgeState dependency : toDownloadInParallel) {
                        buildOperationQueue.add((BuildOperation)new DownloadMetadataOperation(dependency.getTargetComponent()));
                    }
                }
            });
        }
    }

    private ComponentIdentifier toComponentId(ModuleVersionIdentifier id, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        ComponentIdentifier identifier = componentIdentifierCache.get(id);
        if (identifier == null) {
            identifier = DefaultModuleComponentIdentifier.newId(id);
            componentIdentifierCache.put(id, identifier);
        }
        return identifier;
    }

    private void attachToTargetRevisionsSerially(List<EdgeState> dependencies) {
        for (EdgeState dependency : dependencies) {
            if (dependency.getTargetComponent() == null) continue;
            dependency.attachToTargetConfigurations();
        }
    }

    private void validateGraph(ResolveState resolveState) {
        for (ModuleResolveState module : resolveState.getModules()) {
            if (module.getSelected() == null || !module.getSelected().isRejected()) continue;
            throw new GradleException(new RejectedModuleMessageBuilder().buildFailureMessage(module));
        }
    }

    private void assembleResult(ResolveState resolveState, DependencyGraphVisitor visitor) {
        visitor.start(resolveState.getRoot());
        for (DependencyGraphSelector dependencyGraphSelector : resolveState.getSelectors()) {
            visitor.visitSelector(dependencyGraphSelector);
        }
        for (NodeState nodeState : resolveState.getNodes()) {
            if (!nodeState.isSelected()) continue;
            visitor.visitNode(nodeState);
        }
        ArrayList<ComponentState> queue = new ArrayList<ComponentState>();
        for (ModuleResolveState module : resolveState.getModules()) {
            if (module.getSelected() == null) continue;
            queue.add(module.getSelected());
        }
        while (!queue.isEmpty()) {
            ComponentState componentState = (ComponentState)queue.get(0);
            if (componentState.getVisitState() == VisitState.NotSeen) {
                componentState.setVisitState(VisitState.Visiting);
                int pos = 0;
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    for (EdgeState edge : node.getIncomingEdges()) {
                        ComponentState owner = edge.getFrom().getOwner();
                        if (owner.getVisitState() != VisitState.NotSeen) continue;
                        queue.add(pos, owner);
                        ++pos;
                    }
                }
                if (pos != 0) continue;
                componentState.setVisitState(VisitState.Visited);
                queue.remove(0);
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            if (componentState.getVisitState() == VisitState.Visiting) {
                componentState.setVisitState(VisitState.Visited);
                queue.remove(0);
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            queue.remove(0);
        }
        visitor.finish(resolveState.getRoot());
    }

    private static boolean allSelectorsAgreeWith(Collection<SelectorState> allSelectors, String version, Predicate<SelectorState> filter) {
        boolean atLeastOneAgrees = false;
        for (SelectorState selectorState : allSelectors) {
            ResolvedVersionConstraint versionConstraint;
            if (!filter.apply((Object)selectorState) || (versionConstraint = selectorState.getVersionConstraint()) == null) continue;
            VersionSelector candidateSelector = versionConstraint.getPreferredSelector();
            if (candidateSelector == null || !candidateSelector.canShortCircuitWhenVersionAlreadyPreselected() || !candidateSelector.accept(version)) {
                return false;
            }
            candidateSelector = versionConstraint.getRejectedSelector();
            if (candidateSelector != null && candidateSelector.accept(version)) {
                return false;
            }
            atLeastOneAgrees = true;
        }
        return atLeastOneAgrees;
    }

    private static boolean selectorAgreesWith(SelectorState selectorState, String version) {
        ResolvedVersionConstraint versionConstraint = selectorState.getVersionConstraint();
        if (versionConstraint == null || versionConstraint.getPreferredSelector() == null) {
            return false;
        }
        VersionSelector candidateSelector = versionConstraint.getPreferredSelector();
        return !candidateSelector.requiresMetadata() && candidateSelector.canShortCircuitWhenVersionAlreadyPreselected() && candidateSelector.accept(version);
    }

    static enum VisitState {
        NotSeen,
        Visiting,
        Visited;

    }
}

