/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;

public abstract class AbstractDependencyMetadataAdapter<T extends DependencyMetadata>
implements DependencyMetadata<T> {
    private final List<ModuleDependencyMetadata> container;
    private final int originalIndex;

    public AbstractDependencyMetadataAdapter(List<ModuleDependencyMetadata> container, int originalIndex) {
        this.container = container;
        this.originalIndex = originalIndex;
    }

    private ModuleDependencyMetadata getOriginalMetadata() {
        return this.container.get(this.originalIndex);
    }

    private void updateMetadata(ModuleDependencyMetadata modifiedMetadata) {
        this.container.set(this.originalIndex, modifiedMetadata);
    }

    public String getGroup() {
        return this.getOriginalMetadata().getSelector().getGroup();
    }

    public String getName() {
        return this.getOriginalMetadata().getSelector().getModule();
    }

    public VersionConstraint getVersionConstraint() {
        return this.getOriginalMetadata().getSelector().getVersionConstraint();
    }

    public T version(Action<? super MutableVersionConstraint> configureAction) {
        DefaultMutableVersionConstraint mutableVersionConstraint = new DefaultMutableVersionConstraint(this.getVersionConstraint());
        configureAction.execute((Object)mutableVersionConstraint);
        ModuleDependencyMetadata dependencyMetadata = this.getOriginalMetadata().withRequestedVersion(mutableVersionConstraint);
        this.updateMetadata(dependencyMetadata);
        return (T)((DependencyMetadata)Cast.uncheckedCast((Object)this));
    }

    public T because(String reason) {
        this.updateMetadata(this.getOriginalMetadata().withReason(reason));
        return (T)((DependencyMetadata)Cast.uncheckedCast((Object)this));
    }

    public String getReason() {
        return this.getOriginalMetadata().getReason();
    }

    public String toString() {
        return this.getGroup() + ":" + this.getName() + ":" + this.getVersionConstraint();
    }
}

