/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.NoMatchingConfigurationSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;

public abstract class AttributeConfigurationSelector {
    public static ConfigurationMetadata selectConfigurationUsingAttributeMatching(ImmutableAttributes consumerAttributes, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema) {
        List<ConfigurationMetadata> matches;
        ImmutableList<? extends ConfigurationMetadata> consumableConfigurations = targetComponent.getVariantsForGraphTraversal();
        AttributesSchemaInternal producerAttributeSchema = targetComponent.getAttributesSchema();
        AttributeMatcher attributeMatcher = consumerSchema.withProducer(producerAttributeSchema);
        ConfigurationMetadata fallbackConfiguration = targetComponent.getConfiguration("default");
        if (fallbackConfiguration != null && !fallbackConfiguration.isCanBeConsumed()) {
            fallbackConfiguration = null;
        }
        if ((matches = attributeMatcher.matches(consumableConfigurations, (AttributeContainerInternal)consumerAttributes, fallbackConfiguration)).size() == 1) {
            return matches.get(0);
        }
        if (!matches.isEmpty()) {
            throw new AmbiguousConfigurationSelectionException((AttributeContainerInternal)consumerAttributes, attributeMatcher, matches, targetComponent);
        }
        throw new NoMatchingConfigurationSelectionException((AttributeContainerInternal)consumerAttributes, attributeMatcher, targetComponent);
    }
}

