/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.tasks.CompositeTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.DeclaredTaskInputFileProperty;
import org.gradle.api.internal.tasks.DeclaredTaskOutputFileProperty;
import org.gradle.api.internal.tasks.DefaultCacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.DefaultTaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.DefaultTaskInputPropertySpec;
import org.gradle.api.internal.tasks.OutputType;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.ValidationActions;

public class DefaultPropertySpecFactory
implements PropertySpecFactory {
    private final TaskInternal task;
    private final FileResolver resolver;

    public DefaultPropertySpecFactory(TaskInternal task, FileResolver resolver) {
        this.task = task;
        this.resolver = resolver;
    }

    public DeclaredTaskInputFileProperty createInputFileSpec(ValidatingValue paths, ValidationAction validationAction) {
        return new DefaultTaskInputFilePropertySpec(this.task.getName(), this.resolver, paths, validationAction);
    }

    public DeclaredTaskInputFileProperty createInputDirSpec(ValidatingValue dirPath, ValidationAction validator) {
        FileTreeInternal fileTree = this.resolver.resolveFilesAsTree(dirPath);
        return this.createInputFileSpec(new FileTreeValue(dirPath, fileTree), validator);
    }

    public DefaultTaskInputPropertySpec createInputPropertySpec(String name, ValidatingValue value) {
        return new DefaultTaskInputPropertySpec(this.task.getInputs(), name, value);
    }

    public DeclaredTaskOutputFileProperty createOutputFileSpec(ValidatingValue path) {
        return this.createOutputFilePropertySpec(path, OutputType.FILE, ValidationActions.OUTPUT_FILE_VALIDATOR);
    }

    public DeclaredTaskOutputFileProperty createOutputDirSpec(ValidatingValue path) {
        return this.createOutputFilePropertySpec(path, OutputType.DIRECTORY, ValidationActions.OUTPUT_DIRECTORY_VALIDATOR);
    }

    public DeclaredTaskOutputFileProperty createOutputFilesSpec(ValidatingValue paths) {
        return new CompositeTaskOutputPropertySpec(this.task.getName(), this.resolver, OutputType.FILE, paths, ValidationActions.OUTPUT_FILES_VALIDATOR);
    }

    public DeclaredTaskOutputFileProperty createOutputDirsSpec(ValidatingValue paths) {
        return new CompositeTaskOutputPropertySpec(this.task.getName(), this.resolver, OutputType.DIRECTORY, paths, ValidationActions.OUTPUT_DIRECTORIES_VALIDATOR);
    }

    private DefaultCacheableTaskOutputFilePropertySpec createOutputFilePropertySpec(ValidatingValue path, OutputType file, ValidationAction outputFileValidator) {
        return new DefaultCacheableTaskOutputFilePropertySpec(this.task.getName(), this.resolver, file, path, outputFileValidator);
    }

    private static class FileTreeValue
    implements ValidatingValue {
        private final ValidatingValue delegate;
        private final FileTreeInternal fileTree;

        public FileTreeValue(ValidatingValue delegate, FileTreeInternal fileTree) {
            this.delegate = delegate;
            this.fileTree = fileTree;
        }

        @Nullable
        public Object call() {
            return this.fileTree;
        }

        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            this.delegate.validate(propertyName, optional, valueValidator, context);
        }
    }
}

