/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskOutputCachingState;
import org.gradle.api.internal.tasks.DefaultTaskOutputCachingState;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskOutputCachingDisabledReasonCategory;
import org.gradle.api.tasks.TaskState;

public class TaskStateInternal
implements TaskState {
    private boolean executing;
    private boolean actionable = true;
    private boolean didWork;
    private Throwable failure;
    private TaskOutputCachingState taskOutputCaching = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.UNKNOWN, "Cacheability was not determined");
    private TaskExecutionOutcome outcome;

    public boolean getDidWork() {
        return this.didWork;
    }

    public void setDidWork(boolean didWork) {
        this.didWork = didWork;
    }

    public boolean getExecuted() {
        return this.outcome != null;
    }

    public boolean isConfigurable() {
        return !this.getExecuted() && !this.executing;
    }

    public TaskExecutionOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(TaskExecutionOutcome outcome) {
        assert (this.outcome == null);
        this.outcome = outcome;
    }

    public void setOutcome(Throwable failure) {
        assert (this.failure == null);
        this.outcome = TaskExecutionOutcome.EXECUTED;
        this.failure = failure;
    }

    public boolean getExecuting() {
        return this.executing;
    }

    public void setExecuting(boolean executing) {
        this.executing = executing;
    }

    public void setTaskOutputCaching(TaskOutputCachingState taskOutputCaching) {
        this.taskOutputCaching = taskOutputCaching;
    }

    public TaskOutputCachingState getTaskOutputCaching() {
        return this.taskOutputCaching;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public void rethrowFailure() {
        if (this.failure == null) {
            return;
        }
        if (this.failure instanceof RuntimeException) {
            throw (RuntimeException)this.failure;
        }
        if (this.failure instanceof Error) {
            throw (Error)this.failure;
        }
        throw new GradleException("Task failed with an exception.", this.failure);
    }

    public boolean getSkipped() {
        return this.outcome != null && this.outcome.isSkipped();
    }

    public String getSkipMessage() {
        return this.outcome != null ? this.outcome.getMessage() : null;
    }

    public boolean getUpToDate() {
        return this.outcome != null && this.outcome.isUpToDate();
    }

    public boolean getNoSource() {
        return this.outcome == TaskExecutionOutcome.NO_SOURCE;
    }

    public boolean isFromCache() {
        return this.outcome == TaskExecutionOutcome.FROM_CACHE;
    }

    public boolean isActionable() {
        return this.actionable;
    }

    public void setActionable(boolean actionable) {
        this.actionable = actionable;
    }
}

