/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.invocation.BuildController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSrcUpdateFactory
implements Factory<ClassPath> {
    private static final Logger LOGGER = Logging.getLogger(BuildSrcUpdateFactory.class);
    private final BuildController buildController;
    private final BuildSrcBuildListenerFactory listenerFactory;
    private final CachedClasspathTransformer cachedClasspathTransformer;

    public BuildSrcUpdateFactory(BuildController buildController, BuildSrcBuildListenerFactory listenerFactory, CachedClasspathTransformer cachedClasspathTransformer) {
        this.buildController = buildController;
        this.listenerFactory = listenerFactory;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
    }

    public ClassPath create() {
        Collection<File> classpath = this.build();
        LOGGER.debug("Gradle source classpath is: {}", classpath);
        return this.cachedClasspathTransformer.transform((ClassPath)new DefaultClassPath(classpath));
    }

    private Collection<File> build() {
        BuildSrcBuildListenerFactory.Listener listener = this.listenerFactory.create();
        GradleInternal gradle = this.buildController.getGradle();
        gradle.addListener(listener);
        this.buildController.run();
        return listener.getRuntimeClasspath();
    }
}

