/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.BuildIdentity;
import org.gradle.initialization.ProjectPathRegistry;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdeArtifactStore;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Path;

public class DefaultIdeArtifactRegistry
implements IdeArtifactRegistry {
    private final IdeArtifactStore store;
    private final ProjectPathRegistry projectPathRegistry;
    private final DomainObjectContext domainObjectContext;
    private final BuildIdentity buildIdentity;
    private final FileOperations fileOperations;

    public DefaultIdeArtifactRegistry(IdeArtifactStore store, ProjectPathRegistry projectPathRegistry, FileOperations fileOperations, DomainObjectContext domainObjectContext, BuildIdentity buildIdentity) {
        this.store = store;
        this.projectPathRegistry = projectPathRegistry;
        this.fileOperations = fileOperations;
        this.domainObjectContext = domainObjectContext;
        this.buildIdentity = buildIdentity;
    }

    @Override
    public void registerIdeArtifact(IdeProjectMetadata ideProjectMetadata) {
        ProjectComponentIdentifier projectId = DefaultProjectComponentIdentifier.newProjectId((BuildIdentifier)this.buildIdentity.getCurrentBuild(), (String)this.domainObjectContext.getProjectPath().getPath());
        this.store.put(projectId, ideProjectMetadata);
    }

    @Override
    @Nullable
    public <T extends IdeProjectMetadata> T getIdeArtifactMetadata(Class<T> type, ProjectComponentIdentifier project) {
        for (IdeProjectMetadata ideProjectMetadata : this.store.get(project)) {
            if (!type.isInstance(ideProjectMetadata)) continue;
            return (T)((IdeProjectMetadata)type.cast(ideProjectMetadata));
        }
        return null;
    }

    @Override
    public <T extends IdeProjectMetadata> List<IdeArtifactRegistry.Reference<T>> getIdeArtifactMetadata(Class<T> type) {
        ArrayList result = Lists.newArrayList();
        for (Path projectPath : this.projectPathRegistry.getAllExplicitProjectPaths()) {
            ProjectComponentIdentifier projectId = this.projectPathRegistry.getProjectComponentIdentifier(projectPath);
            for (IdeProjectMetadata ideProjectMetadata : this.store.get(projectId)) {
                if (!type.isInstance(ideProjectMetadata)) continue;
                IdeProjectMetadata metadata = (IdeProjectMetadata)type.cast(ideProjectMetadata);
                if (projectId.getBuild().equals(this.buildIdentity.getCurrentBuild())) {
                    result.add(new MetadataFromThisBuild<IdeProjectMetadata>(metadata, projectId));
                    continue;
                }
                result.add(new MetadataFromOtherBuild<IdeProjectMetadata>(metadata, projectId));
            }
        }
        return result;
    }

    @Override
    public FileCollection getIdeArtifacts(final Class<? extends IdeProjectMetadata> type) {
        return this.fileOperations.files(new Object[]{new Callable<List<FileCollection>>(){

            @Override
            public List<FileCollection> call() {
                return CollectionUtils.collect(DefaultIdeArtifactRegistry.this.getIdeArtifactMetadata(type), (Transformer)new Transformer<FileCollection, IdeArtifactRegistry.Reference<?>>(){

                    public FileCollection transform(IdeArtifactRegistry.Reference<?> result) {
                        ConfigurableFileCollection singleton = DefaultIdeArtifactRegistry.this.fileOperations.files(new Object[]{result.get().getFile()});
                        singleton.builtBy(new Object[]{result.getBuildDependencies()});
                        return singleton;
                    }
                });
            }
        }});
    }

    private static class MetadataFromOtherBuild<T extends IdeProjectMetadata>
    extends AbstractReference<T> {
        MetadataFromOtherBuild(T metadata, ProjectComponentIdentifier projectId) {
            super(metadata, projectId);
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return new AbstractTaskDependency(){

                public void visitDependencies(TaskDependencyResolveContext context) {
                    for (Task task : MetadataFromOtherBuild.this.get().getGeneratorTasks()) {
                        context.add((Object)new IncludedBuildTaskReference(MetadataFromOtherBuild.this.getOwningProject().getBuild().getName(), task.getPath()));
                    }
                }
            };
        }
    }

    private static class MetadataFromThisBuild<T extends IdeProjectMetadata>
    extends AbstractReference<T> {
        MetadataFromThisBuild(T metadata, ProjectComponentIdentifier projectId) {
            super(metadata, projectId);
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return new AbstractTaskDependency(){

                public void visitDependencies(TaskDependencyResolveContext context) {
                    for (Task task : MetadataFromThisBuild.this.get().getGeneratorTasks()) {
                        context.add((Object)task);
                    }
                }
            };
        }
    }

    private static abstract class AbstractReference<T extends IdeProjectMetadata>
    implements IdeArtifactRegistry.Reference<T> {
        private final T metadata;
        private final ProjectComponentIdentifier projectId;

        AbstractReference(T metadata, ProjectComponentIdentifier projectId) {
            this.metadata = metadata;
            this.projectId = projectId;
        }

        @Override
        public T get() {
            return this.metadata;
        }

        @Override
        public ProjectComponentIdentifier getOwningProject() {
            return this.projectId;
        }
    }
}

