/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import org.gradle.api.internal.changedetection.state.ClasspathSnapshotter;
import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.internal.run.PlayApplicationRunner;
import org.gradle.play.internal.run.PlayRunAdapterV22X;
import org.gradle.play.internal.run.PlayRunAdapterV23X;
import org.gradle.play.internal.run.PlayRunAdapterV24X;
import org.gradle.play.internal.run.PlayRunAdapterV25X;
import org.gradle.play.internal.run.PlayRunAdapterV26X;
import org.gradle.play.internal.run.VersionedPlayRunAdapter;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class PlayApplicationRunnerFactory {
    public static PlayApplicationRunner create(PlayPlatform playPlatform, WorkerProcessFactory workerFactory, ClasspathSnapshotter snapshotter) {
        return new PlayApplicationRunner(workerFactory, PlayApplicationRunnerFactory.createPlayRunAdapter(playPlatform), snapshotter);
    }

    public static VersionedPlayRunAdapter createPlayRunAdapter(PlayPlatform playPlatform) {
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_2_X: {
                return new PlayRunAdapterV22X();
            }
            case PLAY_2_4_X: {
                return new PlayRunAdapterV24X();
            }
            case PLAY_2_5_X: {
                return new PlayRunAdapterV25X();
            }
            case PLAY_2_6_X: {
                return new PlayRunAdapterV26X();
            }
        }
        return new PlayRunAdapterV23X();
    }
}

