/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.IncompatibleDependencyAttributesMessageBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VariantNameBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CandidateModule;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;

class ModuleResolveState
implements CandidateModule {
    private final ComponentMetaDataResolver metaDataResolver;
    private final IdGenerator<Long> idGenerator;
    private final ModuleIdentifier id;
    private final List<EdgeState> unattachedDependencies = new LinkedList<EdgeState>();
    private final Map<ModuleVersionIdentifier, ComponentState> versions = new LinkedHashMap<ModuleVersionIdentifier, ComponentState>();
    private final List<SelectorState> selectors = Lists.newLinkedList();
    private final VariantNameBuilder variantNameBuilder;
    private final ImmutableAttributesFactory attributesFactory;
    private ComponentState selected;
    private ImmutableAttributes mergedAttributes = ImmutableAttributes.EMPTY;
    private AttributeMergingException attributeMergingError;

    ModuleResolveState(IdGenerator<Long> idGenerator, ModuleIdentifier id, ComponentMetaDataResolver metaDataResolver, VariantNameBuilder variantNameBuilder, ImmutableAttributesFactory attributesFactory) {
        this.idGenerator = idGenerator;
        this.id = id;
        this.metaDataResolver = metaDataResolver;
        this.variantNameBuilder = variantNameBuilder;
        this.attributesFactory = attributesFactory;
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public ModuleIdentifier getId() {
        return this.id;
    }

    public Collection<ComponentState> getVersions() {
        if (this.versions.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<ComponentState> values = this.versions.values();
        if (ModuleResolveState.areAllCandidatesForSelection(values)) {
            return values;
        }
        ArrayList versions = Lists.newArrayListWithCapacity((int)values.size());
        for (ComponentState componentState : values) {
            if (!componentState.isCandidateForConflictResolution()) continue;
            versions.add(componentState);
        }
        return versions;
    }

    private static boolean areAllCandidatesForSelection(Collection<ComponentState> values) {
        boolean allCandidates = true;
        for (ComponentState value : values) {
            if (value.isCandidateForConflictResolution()) continue;
            allCandidates = false;
            break;
        }
        return allCandidates;
    }

    public ComponentState getSelected() {
        return this.selected;
    }

    public void select(ComponentState selected) {
        assert (this.selected == null);
        this.selected = selected;
        this.selectComponentAndEvictOthers(selected);
    }

    private void selectComponentAndEvictOthers(ComponentState selected) {
        for (ComponentState version : this.versions.values()) {
            version.evict();
        }
        selected.select();
    }

    public void changeSelection(ComponentState newSelection) {
        assert (this.selected != null);
        assert (newSelection != null);
        assert (this.selected != newSelection);
        assert (newSelection.getModule() == this);
        this.selected.removeOutgoingEdges();
        this.selected = newSelection;
        this.doRestart(newSelection);
    }

    public void clearSelection() {
        if (this.selected != null) {
            this.selected.removeOutgoingEdges();
        }
        for (ComponentState version : this.versions.values()) {
            if (!version.isSelected()) continue;
            version.makeSelectable();
        }
        this.selected = null;
    }

    public void restart(ComponentState selected) {
        if (this.selected != null) {
            this.clearSelection();
        }
        assert (this.selected == null);
        assert (selected != null);
        this.selected = selected;
        this.doRestart(selected);
    }

    private void doRestart(ComponentState selected) {
        this.selectComponentAndEvictOthers(selected);
        for (ComponentState version : this.versions.values()) {
            version.restartIncomingEdges(selected);
        }
        for (SelectorState selector : this.selectors) {
            selector.overrideSelection(selected);
        }
        if (!this.unattachedDependencies.isEmpty()) {
            this.restartUnattachedDependencies(selected);
        }
    }

    private void restartUnattachedDependencies(ComponentState selected) {
        if (this.unattachedDependencies.size() == 1) {
            this.unattachedDependencies.get(0).restart(selected);
        } else {
            for (EdgeState dependency : new ArrayList<EdgeState>(this.unattachedDependencies)) {
                dependency.restart(selected);
            }
        }
        this.unattachedDependencies.clear();
    }

    public void addUnattachedDependency(EdgeState edge) {
        this.unattachedDependencies.add(edge);
    }

    public void removeUnattachedDependency(EdgeState edge) {
        this.unattachedDependencies.remove(edge);
    }

    public ComponentState getVersion(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier) {
        ComponentState moduleRevision = this.versions.get(id);
        if (moduleRevision == null) {
            moduleRevision = new ComponentState((Long)this.idGenerator.generateId(), this, id, componentIdentifier, this.metaDataResolver, this.variantNameBuilder);
            this.versions.put(id, moduleRevision);
        }
        return moduleRevision;
    }

    public void addSelector(SelectorState selector) {
        this.selectors.add(selector);
        this.mergedAttributes = this.appendAttributes(this.mergedAttributes, selector);
    }

    public List<SelectorState> getSelectors() {
        return this.selectors;
    }

    List<EdgeState> getUnattachedDependencies() {
        return this.unattachedDependencies;
    }

    ImmutableAttributes getMergedSelectorAttributes() {
        if (this.attributeMergingError != null) {
            throw new IllegalStateException(IncompatibleDependencyAttributesMessageBuilder.buildMergeErrorMessage(this, this.attributeMergingError));
        }
        return this.mergedAttributes;
    }

    private ImmutableAttributes appendAttributes(ImmutableAttributes dependencyAttributes, SelectorState selectorState) {
        try {
            ComponentSelector selector = selectorState.getDependencyMetadata().getSelector();
            if (selector instanceof ModuleComponentSelector) {
                ImmutableAttributes attributes = ((AttributeContainerInternal)((ModuleComponentSelector)selector).getAttributes()).asImmutable();
                dependencyAttributes = this.attributesFactory.safeConcat(attributes, dependencyAttributes);
            }
        }
        catch (AttributeMergingException e) {
            this.attributeMergingError = e;
        }
        return dependencyAttributes;
    }

    Set<EdgeState> getIncomingEdges() {
        LinkedHashSet incoming = Sets.newLinkedHashSet();
        if (this.selected != null) {
            for (NodeState nodeState : this.selected.getNodes()) {
                incoming.addAll(nodeState.getIncomingEdges());
            }
        }
        return incoming;
    }
}

