/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.internal.BiAction;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.ModelTypeInitializationException;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractModelCreationRuleExtractor;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodBackedModelAction;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.SpecializedMapSchema;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.SpecializedMapNodeInitializer;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedModelCreationRuleExtractor
extends AbstractModelCreationRuleExtractor {
    private static final ModelType<NodeInitializerRegistry> NODE_INITIALIZER_REGISTRY = ModelType.of(NodeInitializerRegistry.class);
    private final ModelSchemaStore schemaStore;

    public ManagedModelCreationRuleExtractor(ModelSchemaStore schemaStore) {
        this.schemaStore = schemaStore;
    }

    @Override
    public String getDescription() {
        return String.format("%s and taking a managed model element", super.getDescription());
    }

    @Override
    public boolean isSatisfiedBy(MethodRuleDefinition<?, ?> element) {
        return super.isSatisfiedBy(element) && this.isVoidMethod(element);
    }

    @Override
    protected <R, S> void validateMethod(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
        if (ruleDefinition.getReferences().isEmpty()) {
            context.add(ruleDefinition, "A method annotated with @Model must either take at least one parameter or have a non-void return type");
        }
    }

    @Override
    protected <R, S> ExtractedModelRule buildRule(ModelPath modelPath, MethodRuleDefinition<R, S> ruleDefinition) {
        ModelType<S> modelType = ruleDefinition.getSubjectReference().getType();
        ModelSchema<S> modelSchema = this.getModelSchema(modelType, ruleDefinition);
        return new ExtractedManagedCreationRule<R, S>(modelPath, ruleDefinition, modelSchema);
    }

    private static NodeInitializer getNodeInitializer(ModelRuleDescriptor descriptor, ModelSchema<?> modelSchema, NodeInitializerRegistry nodeInitializerRegistry) {
        try {
            return nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forType(modelSchema.getType()));
        }
        catch (ModelTypeInitializationException e) {
            throw new InvalidModelRuleDeclarationException(descriptor, (Throwable)((Object)e));
        }
    }

    private <T> ModelSchema<T> getModelSchema(ModelType<T> managedType, MethodRuleDefinition<?, ?> ruleDefinition) {
        try {
            return this.schemaStore.getSchema(managedType);
        }
        catch (InvalidManagedModelElementTypeException e) {
            throw new InvalidModelRuleDeclarationException(ruleDefinition.getDescriptor(), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractedManagedCreationRule<R, S>
    extends AbstractModelCreationRuleExtractor.ExtractedCreationRule<R, S> {
        private final ModelSchema<S> modelSchema;

        public ExtractedManagedCreationRule(ModelPath modelPath, MethodRuleDefinition<R, S> ruleDefinition, ModelSchema<S> modelSchema) {
            super(modelPath, ruleDefinition);
            this.modelSchema = modelSchema;
        }

        @Override
        protected void buildRegistration(MethodModelRuleApplicationContext context, ModelRegistrations.Builder registration) {
            MethodRuleDefinition ruleDefinition = this.getRuleDefinition();
            List<ModelReference<?>> bindings = ruleDefinition.getReferences();
            List<ModelReference<?>> inputs = bindings.subList(1, bindings.size());
            final ModelRuleDescriptor descriptor = ruleDefinition.getDescriptor();
            if (this.modelSchema instanceof SpecializedMapSchema) {
                registration.actions(SpecializedMapNodeInitializer.getActions(ModelReference.of(this.modelPath), descriptor, (SpecializedMapSchema)this.modelSchema));
            } else {
                registration.action(ModelActionRole.Discover, Collections.singletonList(ModelReference.of(NODE_INITIALIZER_REGISTRY)), new BiAction<MutableModelNode, List<ModelView<?>>>(){

                    public void execute(MutableModelNode node, List<ModelView<?>> modelViews) {
                        NodeInitializerRegistry nodeInitializerRegistry = (NodeInitializerRegistry)modelViews.get(0).getInstance();
                        NodeInitializer initializer = ManagedModelCreationRuleExtractor.getNodeInitializer(descriptor, ExtractedManagedCreationRule.this.modelSchema, nodeInitializerRegistry);
                        for (Map.Entry actionInRole : initializer.getActions(ModelReference.of(ExtractedManagedCreationRule.this.modelPath), descriptor).entries()) {
                            ModelActionRole role = (ModelActionRole)((Object)actionInRole.getKey());
                            ModelAction action = (ModelAction)actionInRole.getValue();
                            node.applyToSelf(role, action);
                        }
                    }
                });
            }
            registration.action(ModelActionRole.Initialize, context.contextualize(new MethodBackedModelAction<S>(descriptor, ModelReference.of(this.modelPath, this.modelSchema.getType()), inputs)));
        }
    }
}

