/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;
import org.gradle.util.CollectionUtils;

public class VisualStudioProjectMetadata
implements IdeProjectMetadata {
    private final DefaultVisualStudioProject project;

    public VisualStudioProjectMetadata(DefaultVisualStudioProject project) {
        this.project = project;
    }

    public String getName() {
        return this.project.getName();
    }

    public File getFile() {
        return this.project.getProjectFile().getLocation();
    }

    public Set<? extends Task> getGeneratorTasks() {
        return this.project.getBuildDependencies().getDependencies(null);
    }

    public List<String> getConfigurations() {
        return CollectionUtils.collect(this.project.getConfigurations(), (Transformer)new Transformer<String, VisualStudioProjectConfiguration>(){

            public String transform(VisualStudioProjectConfiguration configuration) {
                return configuration.getName();
            }
        });
    }
}

