/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.MinusculeMatcher;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.com.intellij.util.ui.KeyboardLayoutUtil;

public class FixingLayoutMatcher
extends MinusculeMatcher {
    @Nullable
    private final MinusculeMatcher myFixedMatcher;

    public FixingLayoutMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        if (pattern == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(0);
        }
        if (options == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(1);
        }
        super(pattern, options, hardSeparators);
        String s = FixingLayoutMatcher.fixLayout(pattern);
        this.myFixedMatcher = s == null ? null : new MinusculeMatcher(s, options, hardSeparators);
    }

    @Nullable
    public static String fixLayout(String pattern) {
        boolean hasLetters = false;
        boolean onlyWrongLetters = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (!Character.isLetter(c)) continue;
            hasLetters = true;
            if (c > '\u007f') continue;
            onlyWrongLetters = false;
            break;
        }
        if (hasLetters && onlyWrongLetters) {
            char[] alternatePattern = new char[pattern.length()];
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                Character newC = KeyboardLayoutUtil.getAsciiForChar(c);
                alternatePattern[i] = newC == null ? c : newC.charValue();
            }
            return new String(alternatePattern);
        }
        return null;
    }

    @Override
    public boolean matches(@NotNull String name) {
        if (name == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(2);
        }
        return super.matches(name) || this.myFixedMatcher != null && this.myFixedMatcher.matches(name);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        if (name == null) {
            FixingLayoutMatcher.$$$reportNull$$$0(3);
        }
        FList<TextRange> ranges2 = super.matchingFragments(name);
        if (this.myFixedMatcher == null || ranges2 != null && !ranges2.isEmpty()) {
            return ranges2;
        }
        return this.myFixedMatcher.matchingFragments(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/FixingLayoutMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "matches";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "matchingFragments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

