/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.IrBinaryPrimitiveImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrUnaryPrimitiveImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.AssignmentGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.OperatorConventionsKt;
import org.jetbrains.kotlin.psi2ir.generators.OperatorExpressionGenerator$WhenMappings;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.psi2ir.intermediate.SafeCallReceiverKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J&\u0010\u000e\u001a\u00020\u00062\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J8\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020!2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020!J\u000e\u0010(\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020)J\u0018\u0010*\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020)2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010-\u001a\u00020.H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0011\u001a\u00020\bH\u0002J(\u00100\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0006H\u0002J\u0016\u00104\u001a\u0004\u0018\u000102*\u00020.2\u0006\u00105\u001a\u00020.H\u0002J \u00106\u001a\u00020\u0006*\u00020\u00122\b\u00107\u001a\u0004\u0018\u00010.2\b\u00108\u001a\u0004\u0018\u00010.H\u0002J \u00109\u001a\u00020\u0006*\u00020\u00062\b\u0010:\u001a\u0004\u0018\u00010.2\b\u00105\u001a\u0004\u0018\u00010.H\u0002\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/OperatorExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateBinaryBooleanOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "irOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "generateBinaryExpression", "generateBinaryOperatorAsCall", "origin", "generateCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateCastExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "generateComparisonOperator", "generateElvis", "generateEquality", "startOffset", "", "endOffset", "arg1", "arg2", "comparisonInfo", "Lorg/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonInfo;", "generateEqualityOperator", "generateExclExclOperator", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "generateIdentityOperator", "generateInOperator", "generateInstanceOfExpression", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "generatePostfixExpression", "generatePrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "generatePrefixOperatorAsCall", "getComparisonOperatorSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "primitiveNumericType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getPrimitiveNumericComparisonInfo", "invokeConversionFunction", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "receiver", "findConversionFunctionTo", "targetType", "generateAsPrimitiveNumericComparisonOperand", "expressionType", "comparisonType", "promoteToPrimitiveNumericType", "operandType", "ir.psi2ir"})
public final class OperatorExpressionGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrExpression generatePrefixExpression(@NotNull KtPrefixExpression expression2) {
        IrExpression irExpression;
        IrStatementOrigin irOperator;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrStatementOrigin irStatementOrigin = irOperator = OperatorConventionsKt.getPrefixOperator(ktOperator);
        if (irStatementOrigin == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected prefix operator: " + ktOperator)));
        }
        if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getINCREMENT_DECREMENT_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generatePrefixIncrementDecrement(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getOPERATORS_DESUGARED_TO_CALLS(), (Object)irStatementOrigin)) {
            irExpression = this.generatePrefixOperatorAsCall(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktOperator.toString()");
            irExpression = GeneratorKt.createDummyExpression(this, ktExpression, string);
        }
        return irExpression;
    }

    @NotNull
    public final IrExpression generatePostfixExpression(@NotNull KtPostfixExpression expression2) {
        IrExpression irExpression;
        IrStatementOrigin irOperator;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrStatementOrigin irStatementOrigin = irOperator = OperatorConventionsKt.getPostfixOperator(ktOperator);
        if (irStatementOrigin == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected postfix operator: " + ktOperator)));
        }
        if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getINCREMENT_DECREMENT_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generatePostfixIncrementDecrement(expression2, irOperator);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEXCL.INSTANCE)) {
            irExpression = this.generateExclExclOperator(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktOperator.toString()");
            irExpression = GeneratorKt.createDummyExpression(this, ktExpression, string);
        }
        return irExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final IrExpression generateCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrTypeOperator irOperator = OperatorConventionsKt.getIrTypeOperator(ktOperator);
        WritableSlice<KtTypeReference, KotlinType> writableSlice = BindingContext.TYPE;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.TYPE");
        ReadOnlySlice readOnlySlice = writableSlice;
        KtTypeReference ktTypeReference = expression2.getRight();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KotlinType rhsType = (KotlinType)GeneratorKt.getOrFail(this, readOnlySlice, ktTypeReference);
        IrTypeOperator irTypeOperator = irOperator;
        if (irTypeOperator == null) throw (Throwable)((Object)new AssertionError((Object)("Unexpected IrTypeOperator: " + (Object)((Object)irOperator))));
        switch (OperatorExpressionGenerator$WhenMappings.$EnumSwitchMapping$0[irTypeOperator.ordinal()]) {
            case 1: {
                kotlinType = rhsType;
                break;
            }
            case 2: {
                KotlinType kotlinType2 = rhsType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"rhsType");
                kotlinType = TypeUtilsKt.makeNullable(kotlinType2);
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected IrTypeOperator: " + (Object)((Object)irOperator))));
            }
        }
        KotlinType resultType = kotlinType;
        int n = PsiUtilsKt.getStartOffset(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        KotlinType kotlinType3 = resultType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"resultType");
        KotlinType kotlinType4 = rhsType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"rhsType");
        KtExpression ktExpression = expression2.getLeft();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left");
        IrExpression irExpression = this.genExpr(ktExpression);
        SymbolTable symbolTable = this.getContext().getSymbolTable();
        ClassifierDescriptor classifierDescriptor = rhsType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor, (String)"rhsType.constructor.declarationDescriptor!!");
        return new IrTypeOperatorCallImpl(n, n2, kotlinType3, irOperator, kotlinType4, irExpression, symbolTable.referenceClassifier(classifierDescriptor));
    }

    @NotNull
    public final IrStatement generateInstanceOfExpression(@NotNull KtIsExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrTypeOperator irTypeOperator = OperatorConventionsKt.getIrTypeOperator(ktOperator);
        if (irTypeOperator == null) {
            Intrinsics.throwNpe();
        }
        IrTypeOperator irOperator = irTypeOperator;
        WritableSlice<KtTypeReference, KotlinType> writableSlice = BindingContext.TYPE;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.TYPE");
        KotlinType againstType = (KotlinType)GeneratorKt.getOrFail(this, writableSlice, expression2.getTypeReference());
        int n = PsiUtilsKt.getStartOffset(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getBooleanType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.booleanType");
        KotlinType kotlinType = simpleType2;
        KotlinType kotlinType2 = againstType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"againstType");
        KtExpression ktExpression = expression2.getLeftHandSide();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.leftHandSide");
        IrExpression irExpression = this.genExpr(ktExpression);
        SymbolTable symbolTable = this.getContext().getSymbolTable();
        ClassifierDescriptor classifierDescriptor = againstType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor, (String)"againstType.constructor.declarationDescriptor!!");
        return new IrTypeOperatorCallImpl(n, n2, kotlinType, irOperator, kotlinType2, irExpression, symbolTable.referenceClassifier(classifierDescriptor));
    }

    @NotNull
    public final IrExpression generateBinaryExpression(@NotNull KtBinaryExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        if (Intrinsics.areEqual((Object)ktOperator, (Object)KtTokens.IDENTIFIER)) {
            return this.generateBinaryOperatorAsCall(expression2, null);
        }
        IrStatementOrigin irOperator = OperatorConventionsKt.getInfixOperator(ktOperator);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (irStatementOrigin == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected infix operator: " + ktOperator)));
        }
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQ.INSTANCE)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generateAssignment(expression2);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getAUGMENTED_ASSIGNMENTS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generateAugmentedAssignment(expression2, irOperator);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.ELVIS.INSTANCE)) {
            irExpression = this.generateElvis(expression2);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getOPERATORS_DESUGARED_TO_CALLS(), (Object)irStatementOrigin)) {
            irExpression = this.generateBinaryOperatorAsCall(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getCOMPARISON_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateComparisonOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getEQUALITY_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateEqualityOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getIDENTITY_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateIdentityOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getIN_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateInOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getBINARY_BOOLEAN_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateBinaryBooleanOperator(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktOperator.toString()");
            irExpression = GeneratorKt.createDummyExpression(this, ktExpression, string);
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateElvis(KtBinaryExpression expression2) {
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> specialCallForElvis = resolvedCall2;
        KotlinType kotlinType = specialCallForElvis.getResultingDescriptor().getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType resultType = kotlinType;
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = this.genExpr(ktExpression);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = this.genExpr(ktExpression2);
        OperatorExpressionGenerator operatorExpressionGenerator = this;
        IrStatementOrigin origin$iv = IrStatementOrigin.ELVIS.INSTANCE;
        IrGeneratorWithScope irGeneratorWithScope = (IrGeneratorWithScope)$receiver$iv;
        int n = KotlinUtilsKt.getStartOffsetOrUndefined(expression2);
        int endOffset$iv$iv = KotlinUtilsKt.getEndOffsetOrUndefined(expression2);
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($receiver$iv$iv.getContext(), $receiver$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType);
        void $receiver = this_$iv$iv$iv;
        IrVariable temporary = ExpressionHelpersKt.irTemporary((IrStatementsBuilder)$receiver, irArgument0, "elvis_lhs");
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$receiver;
        KotlinType kotlinType2 = resultType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"resultType");
        $receiver.unaryPlus(ExpressionHelpersKt.irIfNull(irBuilderWithScope, kotlinType2, ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, (IrValueSymbol)temporary.getSymbol()), irArgument1, ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, (IrValueSymbol)temporary.getSymbol())));
        return this_$iv$iv$iv.doBuild();
    }

    private final IrExpression generateBinaryBooleanOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = this.genExpr(ktExpression);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = this.genExpr(ktExpression2);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.OROR.INSTANCE)) {
            irExpression = PrimitivesKt.oror$default(this.getContext(), PsiUtilsKt.getStartOffset(expression2), PsiUtilsKt.getEndOffset(expression2), irArgument0, irArgument1, null, 16, null);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.ANDAND.INSTANCE)) {
            irExpression = PrimitivesKt.andand$default(this.getContext(), PsiUtilsKt.getStartOffset(expression2), PsiUtilsKt.getEndOffset(expression2), irArgument0, irArgument1, null, 16, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected binary boolean operator " + irOperator)));
        }
        return irExpression;
    }

    private final IrExpression generateInOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> containsCall = resolvedCall2;
        IrExpression irContainsCall = this.generateCall(containsCall, expression2, irOperator);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.IN.INSTANCE)) {
            irExpression = irContainsCall;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.NOT_IN.INSTANCE)) {
            irExpression = new IrUnaryPrimitiveImpl(PsiUtilsKt.getStartOffset(expression2), PsiUtilsKt.getEndOffset(expression2), (IrStatementOrigin)IrStatementOrigin.NOT_IN.INSTANCE, this.getContext().getIrBuiltIns().getBooleanNotSymbol(), irContainsCall);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected in-operator " + irOperator)));
        }
        return irExpression;
    }

    private final IrExpression generateIdentityOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = this.genExpr(ktExpression);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = this.genExpr(ktExpression2);
        IrBinaryPrimitiveImpl irIdentityEquals = new IrBinaryPrimitiveImpl(PsiUtilsKt.getStartOffset(expression2), PsiUtilsKt.getEndOffset(expression2), irOperator, this.getContext().getIrBuiltIns().getEqeqeqSymbol(), irArgument0, irArgument1);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQEQEQ.INSTANCE)) {
            irExpression = irIdentityEquals;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEQEQ.INSTANCE)) {
            irExpression = new IrUnaryPrimitiveImpl(PsiUtilsKt.getStartOffset(expression2), PsiUtilsKt.getEndOffset(expression2), (IrStatementOrigin)IrStatementOrigin.EXCLEQEQ.INSTANCE, this.getContext().getIrBuiltIns().getBooleanNotSymbol(), (IrExpression)irIdentityEquals);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected identity operator " + irOperator)));
        }
        return irExpression;
    }

    private final IrExpression generateAsPrimitiveNumericComparisonOperand(@NotNull KtExpression $receiver, KotlinType expressionType, KotlinType comparisonType) {
        return this.promoteToPrimitiveNumericType(this.genExpr($receiver), expressionType, comparisonType);
    }

    private final PrimitiveNumericComparisonInfo getPrimitiveNumericComparisonInfo(KtBinaryExpression ktExpression) {
        return (PrimitiveNumericComparisonInfo)this.getContext().getBindingContext().get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, ktExpression);
    }

    private final IrExpression generateEqualityOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        PrimitiveNumericComparisonInfo comparisonInfo;
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo = comparisonInfo = this.getPrimitiveNumericComparisonInfo(expression2);
        KotlinType comparisonType = primitiveNumericComparisonInfo != null ? primitiveNumericComparisonInfo.getComparisonType() : null;
        Map<SimpleType, IrSimpleFunction> map2 = this.getContext().getIrBuiltIns().getIeee754equalsFunByOperandType();
        Object object = map2.get(comparisonType);
        if (object == null || (object = (IrSimpleFunctionSymbol)object.getSymbol()) == null) {
            object = this.getContext().getIrBuiltIns().getEqeqSymbol();
        }
        Object eqeqSymbol = object;
        int n = PsiUtilsKt.getStartOffset(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        IrFunctionSymbol irFunctionSymbol = (IrFunctionSymbol)eqeqSymbol;
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo2 = comparisonInfo;
        IrExpression irExpression2 = this.generateAsPrimitiveNumericComparisonOperand(ktExpression, primitiveNumericComparisonInfo2 != null ? primitiveNumericComparisonInfo2.getLeftType() : null, comparisonType);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo3 = comparisonInfo;
        IrBinaryPrimitiveImpl irEquals = new IrBinaryPrimitiveImpl(n, n2, irOperator, irFunctionSymbol, irExpression2, this.generateAsPrimitiveNumericComparisonOperand(ktExpression2, primitiveNumericComparisonInfo3 != null ? primitiveNumericComparisonInfo3.getRightType() : null, comparisonType));
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQEQ.INSTANCE)) {
            irExpression = irEquals;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEQ.INSTANCE)) {
            irExpression = new IrUnaryPrimitiveImpl(PsiUtilsKt.getStartOffset(expression2), PsiUtilsKt.getEndOffset(expression2), (IrStatementOrigin)IrStatementOrigin.EXCLEQ.INSTANCE, this.getContext().getIrBuiltIns().getBooleanNotSymbol(), (IrExpression)irEquals);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected equality operator " + irOperator)));
        }
        return irExpression;
    }

    @NotNull
    public final IrExpression generateEquality(int startOffset, int endOffset, @NotNull IrStatementOrigin irOperator, @NotNull IrExpression arg1, @NotNull IrExpression arg2, @Nullable PrimitiveNumericComparisonInfo comparisonInfo) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)irOperator, (String)"irOperator");
        Intrinsics.checkParameterIsNotNull((Object)arg1, (String)"arg1");
        Intrinsics.checkParameterIsNotNull((Object)arg2, (String)"arg2");
        if (comparisonInfo != null) {
            KotlinType comparisonType = comparisonInfo.getComparisonType();
            Map<SimpleType, IrSimpleFunction> map2 = this.getContext().getIrBuiltIns().getIeee754equalsFunByOperandType();
            Object object = map2.get(comparisonType);
            if (object == null || (object = (IrSimpleFunctionSymbol)object.getSymbol()) == null) {
                object = this.getContext().getIrBuiltIns().getEqeqSymbol();
            }
            Object eqeqSymbol = object;
            irExpression = new IrBinaryPrimitiveImpl(startOffset, endOffset, irOperator, (IrFunctionSymbol)eqeqSymbol, this.promoteToPrimitiveNumericType(arg1, comparisonInfo.getLeftType(), comparisonType), this.promoteToPrimitiveNumericType(arg2, comparisonInfo.getRightType(), comparisonType));
        } else {
            irExpression = new IrBinaryPrimitiveImpl(startOffset, endOffset, irOperator, this.getContext().getIrBuiltIns().getEqeqSymbol(), arg1, arg2);
        }
        return irExpression;
    }

    private final IrExpression promoteToPrimitiveNumericType(@NotNull IrExpression $receiver, KotlinType operandType, KotlinType targetType) {
        IrExpression irExpression;
        if (targetType == null) {
            return $receiver;
        }
        if (operandType == null) {
            throw (Throwable)((Object)new AssertionError((Object)"operandType should be non-null"));
        }
        KotlinType operandNNType = TypeUtilsKt.makeNotNullable(operandType);
        FunctionDescriptor conversionFunction = this.findConversionFunctionTo(operandNNType, targetType);
        if (!TypeUtilsKt.isPrimitiveNumberType(operandNNType)) {
            throw (Throwable)((Object)new AssertionError((Object)("Primitive number type or nullable primitive number type expected: " + $receiver.getType())));
        }
        if (Intrinsics.areEqual((Object)operandType, (Object)targetType) || Intrinsics.areEqual((Object)operandNNType, (Object)targetType)) {
            irExpression = $receiver;
        } else if (KotlinUtilsKt.containsNull($receiver.getType())) {
            irExpression = SafeCallReceiverKt.safeCallOnDispatchReceiver($receiver, this, $receiver.getStartOffset(), $receiver.getEndOffset(), (Function1<? super IrExpression, ? extends IrExpression>)((Function1)new Function1<IrExpression, IrExpression>(this, $receiver, conversionFunction, targetType){
                final /* synthetic */ OperatorExpressionGenerator this$0;
                final /* synthetic */ IrExpression receiver$0;
                final /* synthetic */ FunctionDescriptor $conversionFunction;
                final /* synthetic */ KotlinType $targetType;

                @NotNull
                public final IrExpression invoke(@NotNull IrExpression dispatchReceiver) {
                    Intrinsics.checkParameterIsNotNull((Object)dispatchReceiver, (String)"dispatchReceiver");
                    FunctionDescriptor functionDescriptor = this.$conversionFunction;
                    if (functionDescriptor == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("No conversion function for " + this.receiver$0.getType() + " ~> " + this.$targetType)));
                    }
                    return OperatorExpressionGenerator.access$invokeConversionFunction(this.this$0, this.receiver$0.getStartOffset(), this.receiver$0.getEndOffset(), functionDescriptor, dispatchReceiver);
                }
                {
                    this.this$0 = operatorExpressionGenerator;
                    this.receiver$0 = irExpression;
                    this.$conversionFunction = functionDescriptor;
                    this.$targetType = kotlinType;
                    super(1);
                }
            }));
        } else {
            FunctionDescriptor functionDescriptor = conversionFunction;
            if (functionDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No conversion function for " + $receiver.getType() + " ~> " + targetType)));
            }
            irExpression = this.invokeConversionFunction($receiver.getStartOffset(), $receiver.getEndOffset(), functionDescriptor, $receiver);
        }
        return irExpression;
    }

    private final IrExpression invokeConversionFunction(int startOffset, int endOffset, FunctionDescriptor functionDescriptor, IrExpression receiver) {
        IrCallImpl irCallImpl;
        KotlinType kotlinType = functionDescriptor.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"functionDescriptor.returnType!!");
        SymbolTable symbolTable = this.getContext().getSymbolTable();
        FunctionDescriptor functionDescriptor2 = functionDescriptor.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor.original");
        IrCallImpl $receiver = irCallImpl = new IrCallImpl(startOffset, endOffset, kotlinType, symbolTable.referenceFunction(functionDescriptor2), functionDescriptor, null, null, null);
        $receiver.setDispatchReceiver(receiver);
        return irCallImpl;
    }

    private final FunctionDescriptor findConversionFunctionTo(@NotNull KotlinType $receiver, KotlinType targetType) {
        Object object = targetType.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = object.getName()) == null || (object = ((Name)object).asString()) == null) {
            return null;
        }
        Object targetTypeName = object;
        MemberScope memberScope2 = $receiver.getMemberScope();
        Name name = Name.identifier("to" + (String)targetTypeName);
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"to$targetTypeName\")");
        return KotlinUtilsKt.findSingleFunction(memberScope2, name);
    }

    private final IrExpression generateComparisonOperator(KtBinaryExpression expression2, IrStatementOrigin origin) {
        IrExpression irExpression;
        int startOffset = PsiUtilsKt.getStartOffset(expression2);
        int endOffset = PsiUtilsKt.getEndOffset(expression2);
        PrimitiveNumericComparisonInfo comparisonInfo = this.getPrimitiveNumericComparisonInfo(expression2);
        if (comparisonInfo != null) {
            IrFunctionSymbol irFunctionSymbol = this.getComparisonOperatorSymbol(origin, comparisonInfo.getComparisonType());
            KtExpression ktExpression = expression2.getLeft();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
            IrExpression irExpression2 = this.generateAsPrimitiveNumericComparisonOperand(ktExpression, comparisonInfo.getLeftType(), comparisonInfo.getComparisonType());
            KtExpression ktExpression2 = expression2.getRight();
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
            irExpression = new IrBinaryPrimitiveImpl(startOffset, endOffset, origin, irFunctionSymbol, irExpression2, this.generateAsPrimitiveNumericComparisonOperand(ktExpression2, comparisonInfo.getRightType(), comparisonInfo.getComparisonType()));
        } else {
            IrFunctionSymbol irFunctionSymbol = this.getComparisonOperatorSymbol(origin, this.getContext().getIrBuiltIns().getInt());
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
            if (resolvedCall2 == null) {
                Intrinsics.throwNpe();
            }
            IrExpression irExpression3 = this.generateCall(resolvedCall2, expression2, origin);
            SimpleType simpleType2 = this.getContext().getBuiltIns().getIntType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.intType");
            irExpression = new IrBinaryPrimitiveImpl(startOffset, endOffset, origin, irFunctionSymbol, irExpression3, (IrExpression)IrConstImpl.Companion.int(startOffset, endOffset, simpleType2, 0));
        }
        return irExpression;
    }

    private final IrExpression generateCall(ResolvedCall<?> resolvedCall2, KtExpression ktExpression, IrStatementOrigin origin) {
        return CallGeneratorKt.generateCall(new CallGenerator(this.getStatementGenerator()), ktExpression, ArgumentsGenerationUtilsKt.pregenerateCall(this.getStatementGenerator(), resolvedCall2), origin);
    }

    private final IrSimpleFunctionSymbol getComparisonOperatorSymbol(IrStatementOrigin origin, KotlinType primitiveNumericType) {
        Map<SimpleType, IrSimpleFunction> map2;
        Object object = origin;
        if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.LT.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getLessFunByOperandType();
        } else if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.LTEQ.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getLessOrEqualFunByOperandType();
        } else if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.GT.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getGreaterFunByOperandType();
        } else if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.GTEQ.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getGreaterOrEqualFunByOperandType();
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected comparison operator: " + origin)));
        }
        object = map2;
        Object v = object.get(primitiveNumericType);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (IrSimpleFunctionSymbol)((IrSimpleFunction)v).getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateExclExclOperator(KtPostfixExpression expression2, IrStatementOrigin origin) {
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $receiver$iv$iv;
        KtExpression ktArgument;
        KtExpression ktExpression = expression2.getBaseExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression2 = ktArgument = ktExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktArgument");
        IrExpression irArgument = this.genExpr(ktExpression2);
        KtSimpleNameExpression ktOperator = expression2.getOperationReference();
        KotlinType resultType = TypeUtilsKt.makeNotNullable(irArgument.getType());
        OperatorExpressionGenerator $receiver$iv = this;
        IrGeneratorWithScope irGeneratorWithScope = $receiver$iv;
        int n = KotlinUtilsKt.getStartOffsetOrUndefined(ktOperator);
        int endOffset$iv$iv = KotlinUtilsKt.getEndOffsetOrUndefined(ktOperator);
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($receiver$iv$iv.getContext(), $receiver$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin, resultType);
        void $receiver = this_$iv$iv$iv;
        IrVariable temporary = ExpressionHelpersKt.irTemporary((IrStatementsBuilder)$receiver, irArgument, "notnull");
        $receiver.unaryPlus(ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$receiver, resultType, ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, (IrValueSymbol)temporary.getSymbol()), ExpressionHelpersKt.irThrowNpe((IrBuilderWithScope)$receiver, origin), ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, (IrValueSymbol)temporary.getSymbol())));
        return this_$iv$iv$iv.doBuild();
    }

    private final IrExpression generateBinaryOperatorAsCall(KtBinaryExpression expression2, IrStatementOrigin origin) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        return this.generateCall(resolvedCall2, expression2, origin);
    }

    private final IrExpression generatePrefixOperatorAsCall(KtPrefixExpression expression2, IrStatementOrigin origin) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (expression2.getBaseExpression() instanceof KtConstantExpression) {
            CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, this.getContext().getBindingContext());
            if (compileTimeConstant != null) {
                KotlinType receiverType;
                CompileTimeConstant<?> compileTimeConstant2;
                CompileTimeConstant<?> constant = compileTimeConstant2 = compileTimeConstant;
                ReceiverValue receiverValue = resolvedCall3.getDispatchReceiver();
                KotlinType kotlinType = receiverType = receiverValue != null ? receiverValue.getType() : null;
                if (receiverType != null && KotlinBuiltIns.isPrimitiveType(receiverType)) {
                    return this.getStatementGenerator().generateConstantExpression(expression2, constant);
                }
            }
        }
        return this.generateCall(resolvedCall3, expression2, origin);
    }

    public OperatorExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$invokeConversionFunction(OperatorExpressionGenerator $this, int startOffset, int endOffset, @NotNull FunctionDescriptor functionDescriptor, @NotNull IrExpression receiver) {
        return $this.invokeConversionFunction(startOffset, endOffset, functionDescriptor, receiver);
    }
}

