/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.api.internal.WithEstimatedSize;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Actions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDomainObjectSet<T>
extends DelegatingDomainObjectSet<T>
implements WithEstimatedSize {
    private final Spec<T> uniqueSpec = new ItemIsUniqueInCompositeSpec();
    private final Spec<T> notInSpec = new ItemNotInCompositeSpec();
    private final DefaultDomainObjectSet<T> backingSet;

    public static <T> CompositeDomainObjectSet<T> create(Class<T> type, DomainObjectCollection<? extends T> ... collections) {
        DefaultDomainObjectSet<T> backingSet = new DefaultDomainObjectSet<T>(type, new DomainObjectCompositeCollection());
        CompositeDomainObjectSet<? extends T> out = new CompositeDomainObjectSet<T>(backingSet);
        for (DomainObjectCollection<? extends T> c : collections) {
            out.addCollection(c);
        }
        return out;
    }

    CompositeDomainObjectSet(DefaultDomainObjectSet<T> backingSet) {
        super(backingSet);
        this.backingSet = backingSet;
    }

    protected DomainObjectCompositeCollection<T> getStore() {
        return (DomainObjectCompositeCollection)this.backingSet.getStore();
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return super.whenObjectAdded(Actions.filter(action, this.uniqueSpec));
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return super.whenObjectRemoved(Actions.filter(action, this.notInSpec));
    }

    public void addCollection(DomainObjectCollection<? extends T> collection) {
        if (!this.getStore().containsCollection(collection)) {
            this.getStore().addComposited(collection);
            collection.all(this.backingSet.getEventRegister().getAddAction());
            collection.whenObjectRemoved(this.backingSet.getEventRegister().getRemoveAction());
        }
    }

    public void removeCollection(DomainObjectCollection<? extends T> collection) {
        this.getStore().removeComposited(collection);
        Action action = this.backingSet.getEventRegister().getRemoveAction();
        for (Object item : collection) {
            action.execute(item);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.getStore().iterator();
    }

    @Override
    public int size() {
        return this.getStore().size();
    }

    @Override
    public int estimatedSize() {
        return this.getStore().estimatedSize();
    }

    @Override
    public void all(Action<? super T> action) {
        this.whenObjectAdded(action);
        Iterator<T> i$ = this.iterator();
        while (i$.hasNext()) {
            T t = i$.next();
            action.execute(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DomainObjectCompositeCollection<T>
    implements ElementSource<T> {
        private final List<DomainObjectCollection<? extends T>> store = Lists.newLinkedList();

        private DomainObjectCompositeCollection() {
        }

        public boolean containsCollection(DomainObjectCollection<? extends T> collection) {
            for (DomainObjectCollection<? extends T> domainObjectCollection : this.store) {
                if (domainObjectCollection != collection) continue;
                return true;
            }
            return false;
        }

        Set<T> collect() {
            if (this.store.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet tmp = Sets.newLinkedHashSetWithExpectedSize((int)this.estimatedSize());
            for (DomainObjectCollection<? extends T> domainObjectCollection : this.store) {
                tmp.addAll(domainObjectCollection);
            }
            return tmp;
        }

        @Override
        public int size() {
            return this.collect().size();
        }

        @Override
        public boolean isEmpty() {
            for (DomainObjectCollection<? extends T> domainObjectCollection : this.store) {
                if (domainObjectCollection.isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object o) {
            for (DomainObjectCollection<? extends T> domainObjectCollection : this.store) {
                if (!domainObjectCollection.contains(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.store.isEmpty()) {
                return Iterators.emptyIterator();
            }
            if (this.store.size() == 1) {
                return this.store.get(0).iterator();
            }
            return this.collect().iterator();
        }

        @Override
        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void addComposited(DomainObjectCollection<? extends T> collection) {
            this.store.add(collection);
        }

        public void removeComposited(DomainObjectCollection<? extends T> collection) {
            Iterator<DomainObjectCollection<T>> iterator = this.store.iterator();
            while (iterator.hasNext()) {
                DomainObjectCollection<? extends T> next = iterator.next();
                if (next != collection) continue;
                iterator.remove();
                break;
            }
        }

        @Override
        public boolean constantTimeIsEmpty() {
            return this.store.isEmpty();
        }

        @Override
        public int estimatedSize() {
            int size = 0;
            for (DomainObjectCollection<? extends T> domainObjectCollection : this.store) {
                size += WithEstimatedSize.Estimates.estimateSizeOf(domainObjectCollection);
            }
            return size;
        }

        @Override
        public Iterator<T> iteratorNoFlush() {
            return this.iterator();
        }

        @Override
        public void realizePending() {
        }

        @Override
        public void realizePending(Class<?> type) {
        }

        @Override
        public void addPending(ProviderInternal<? extends T> provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removePending(ProviderInternal<? extends T> provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onRealize(Action<ProviderInternal<? extends T>> action) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemNotInCompositeSpec
    implements Spec<T> {
        public boolean isSatisfiedBy(T element) {
            return !CompositeDomainObjectSet.this.getStore().contains(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemIsUniqueInCompositeSpec
    implements Spec<T> {
        public boolean isSatisfiedBy(T element) {
            int matches = 0;
            for (DomainObjectCollection collection : CompositeDomainObjectSet.this.getStore().store) {
                if (!collection.contains(element) || ++matches <= 1) continue;
                return false;
            }
            return true;
        }
    }
}

