/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureByMapAction<T>
implements Action<T> {
    private final Map<?, ?> properties;
    private final Collection<?> mandatoryProperties;

    public ConfigureByMapAction(Map<?, ?> properties) {
        this(properties, Collections.emptySet());
    }

    public ConfigureByMapAction(Map<?, ?> properties, Collection<?> mandatoryProperties) {
        this.properties = properties;
        this.mandatoryProperties = mandatoryProperties;
    }

    public void execute(T thing) {
        ConfigureUtil.configureByMap(this.properties, thing, this.mandatoryProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigureByMapAction that = (ConfigureByMapAction)o;
        if (!this.mandatoryProperties.equals(that.mandatoryProperties)) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.properties.hashCode();
        result = 31 * result + this.mandatoryProperties.hashCode();
        return result;
    }
}

