/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.DeclaredTaskInputProperty;
import org.gradle.api.internal.tasks.LenientTaskInputsDeprecationSupport;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationActions;
import org.gradle.api.tasks.TaskInputPropertyBuilder;
import org.gradle.api.tasks.TaskInputs;

@NonNullApi
public class DefaultTaskInputPropertySpec
extends LenientTaskInputsDeprecationSupport
implements DeclaredTaskInputProperty {
    private final String propertyName;
    private final ValidatingValue value;
    private boolean optional;

    public DefaultTaskInputPropertySpec(TaskInputs taskInputs, String propertyName, ValidatingValue value) {
        super(taskInputs);
        this.propertyName = propertyName;
        this.value = value;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public TaskInputPropertyBuilder optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    @Nullable
    public Object getValue() {
        return this.value.call();
    }

    public void validate(TaskValidationContext context) {
        this.value.validate(this.getPropertyName(), this.optional, ValidationActions.NO_OP, context);
    }

    public int compareTo(TaskPropertySpec o) {
        return this.getPropertyName().compareTo(o.getPropertyName());
    }

    public String toString() {
        return this.propertyName;
    }
}

