/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.annotations;

import java.lang.annotation.Annotation;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.properties.BeanPropertyContext;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedBeanAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return Nested.class;
    }

    @Override
    public void visitPropertyValue(PropertyValue propertyValue, PropertyVisitor visitor, PropertySpecFactory specFactory, BeanPropertyContext context) {
        Object nested;
        try {
            nested = NestedBeanAnnotationHandler.unpackProvider(propertyValue.getValue());
        }
        catch (Exception e) {
            visitor.visitInputProperty(specFactory.createInputPropertySpec(propertyValue.getPropertyName(), new InvalidPropertyValue(e)));
            return;
        }
        if (nested != null) {
            context.addNested(propertyValue.getPropertyName(), nested);
        } else if (!propertyValue.isOptional()) {
            visitor.visitInputProperty(specFactory.createInputPropertySpec(propertyValue.getPropertyName(), new AbsentPropertyValue()));
        }
    }

    @Nullable
    private static Object unpackProvider(@Nullable Object value) {
        if (value instanceof Provider) {
            return ((Provider)value).get();
        }
        return value;
    }

    private static class AbsentPropertyValue
    implements ValidatingValue {
        private AbsentPropertyValue() {
        }

        @Nullable
        public Object call() {
            return null;
        }

        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            context.recordValidationMessage(TaskValidationContext.Severity.ERROR, String.format("No value has been specified for property '%s'.", propertyName));
        }
    }

    private static class InvalidPropertyValue
    implements ValidatingValue {
        private final Exception exception;

        public InvalidPropertyValue(Exception exception) {
            this.exception = exception;
        }

        @Nullable
        public Object call() {
            return null;
        }

        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            throw UncheckedException.throwAsUncheckedException((Throwable)this.exception);
        }
    }
}

