/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.BuildType;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftExecutable;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftApplication;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.util.GUtil;

@Incubating
public class SwiftApplicationPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public SwiftApplicationPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ImmutableAttributesFactory attributesFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.attributesFactory = attributesFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        ConfigurationContainer configurations = project.getConfigurations();
        final DefaultSwiftApplication application = this.componentFactory.newInstance(SwiftApplication.class, DefaultSwiftApplication.class, "main");
        project.getExtensions().add(SwiftApplication.class, "application", (Object)application);
        project.getComponents().add((Object)application);
        application.getModule().set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                application.getOperatingSystems().lockNow();
                Set operatingSystemFamilies = (Set)application.getOperatingSystems().get();
                if (operatingSystemFamilies.isEmpty()) {
                    throw new IllegalArgumentException("An operating system needs to be specified for the application.");
                }
                ObjectFactory objectFactory = project.getObjects();
                Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
                for (BuildType buildType : BuildType.DEFAULT_BUILD_TYPES) {
                    for (OperatingSystemFamily operatingSystem : operatingSystemFamilies) {
                        String operatingSystemSuffix = SwiftApplicationPlugin.this.createDimensionSuffix((Named)operatingSystem, operatingSystemFamilies);
                        String variantName = buildType.getName() + operatingSystemSuffix;
                        Provider group = project.provider((Callable)new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return project.getGroup().toString();
                            }
                        });
                        Provider version = project.provider((Callable)new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return project.getVersion().toString();
                            }
                        });
                        AttributeContainerInternal runtimeAttributes = SwiftApplicationPlugin.this.attributesFactory.mutable();
                        runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                        runtimeAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)buildType.isDebuggable());
                        runtimeAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)buildType.isOptimized());
                        runtimeAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)operatingSystem);
                        NativeVariantIdentity variantIdentity = new NativeVariantIdentity(variantName, (Provider<String>)application.getModule(), (Provider<String>)group, (Provider<String>)version, buildType.isDebuggable(), buildType.isOptimized(), operatingSystem, null, new DefaultUsageContext(variantName + "-runtime", runtimeUsage, (AttributeContainer)runtimeAttributes));
                        if (!DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(operatingSystem.getName())) continue;
                        ToolChainSelector.Result<SwiftPlatform> result = SwiftApplicationPlugin.this.toolChainSelector.select(SwiftPlatform.class);
                        SwiftExecutable executable = application.addExecutable(variantIdentity, buildType == BuildType.DEBUG, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                        if (buildType != BuildType.DEBUG) continue;
                        application.getDevelopmentBinary().set((Object)executable);
                    }
                }
                ((DefaultBinaryCollection)application.getBinaries()).realizeNow();
            }
        });
    }

    private String createDimensionSuffix(Named dimensionValue, Collection<? extends Named> multivalueProperty) {
        if (this.isDimensionVisible(multivalueProperty)) {
            return StringUtils.capitalize((String)dimensionValue.getName().toLowerCase());
        }
        return "";
    }

    private boolean isDimensionVisible(Collection<? extends Named> multivalueProperty) {
        return multivalueProperty.size() > 1;
    }
}

