/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.compile.incremental.AnnotationProcessorChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.ClassChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.JavaChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.FileUtils;

class InputChangeAction
implements Action<InputFileDetails> {
    private final RecompilationSpec spec;
    private final JavaChangeProcessor javaChangeProcessor;
    private final ClassChangeProcessor classChangeProcessor;
    private final AnnotationProcessorChangeProcessor annotationProcessorChangeProcessor;

    InputChangeAction(RecompilationSpec spec, JavaChangeProcessor javaChangeProcessor, ClassChangeProcessor classChangeProcessor, AnnotationProcessorChangeProcessor annotationProcessorChangeProcessor) {
        this.spec = spec;
        this.javaChangeProcessor = javaChangeProcessor;
        this.classChangeProcessor = classChangeProcessor;
        this.annotationProcessorChangeProcessor = annotationProcessorChangeProcessor;
    }

    public void execute(InputFileDetails input) {
        if (this.spec.getFullRebuildCause() != null) {
            return;
        }
        this.annotationProcessorChangeProcessor.processChange(input, this.spec);
        if (FileUtils.hasExtension((File)input.getFile(), (String)".java")) {
            this.javaChangeProcessor.processChange(input, this.spec);
        } else if (FileUtils.hasExtension((File)input.getFile(), (String)".class")) {
            this.classChangeProcessor.processChange(input, this.spec);
        }
    }
}

