/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.console;

import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixConsoleMetaData
implements ConsoleMetaData {
    public static final Logger LOGGER = LoggerFactory.getLogger(UnixConsoleMetaData.class);
    private final boolean stdout;
    private final boolean stderr;

    public UnixConsoleMetaData(boolean stdout, boolean stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public boolean isStdOut() {
        return this.stdout;
    }

    public boolean isStdErr() {
        return this.stderr;
    }

    public int getCols() {
        String columns = System.getenv("COLUMNS");
        if (columns != null) {
            try {
                return Integer.parseInt(columns);
            }
            catch (NumberFormatException ex) {
                LOGGER.debug("Cannot parse COLUMNS environment variable to get console width. Value: '{}'", (Object)columns);
            }
        }
        return 0;
    }

    public int getRows() {
        String rows = System.getenv("LINES");
        if (rows != null) {
            try {
                return Integer.parseInt(rows);
            }
            catch (NumberFormatException ex) {
                LOGGER.debug("Cannot parse LINES environment variable to get console height. Value: '{}'", (Object)rows);
            }
        }
        return 0;
    }
}

