/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.GradleException;
import org.gradle.internal.exceptions.Contextual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModelPath
implements Iterable<String>,
Comparable<ModelPath> {
    private static final String SEPARATOR = ".";
    private static final CharMatcher VALID_FIRST_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.is((char)'_'));
    private static final CharMatcher INVALID_FIRST_CHAR_MATCHER = VALID_FIRST_CHAR_MATCHER.negate().precomputed();
    private static final CharMatcher INVALID_CHAR_MATCHER = CharMatcher.inRange((char)'0', (char)'9').or(VALID_FIRST_CHAR_MATCHER).or(CharMatcher.is((char)'-')).negate().precomputed();
    public static final ModelPath ROOT = new ModelPath("", new String[0]){

        public String toString() {
            return "<root>";
        }
    };
    private static final Cache BY_PATH = new Cache(ROOT);
    private final String path;
    private final String[] components;
    private final ModelPath parent;

    public ModelPath(String path) {
        this(path, ModelPath.splitPath(path));
    }

    private ModelPath(String path, String[] components) {
        this.path = path;
        this.components = components;
        this.parent = this.doGetParent();
    }

    @Override
    public int compareTo(ModelPath other) {
        if (this == other) {
            return 0;
        }
        return this.path.compareTo(other.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelPath modelPath = (ModelPath)o;
        return this.components.length == modelPath.components.length && this.path.equals(modelPath.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public Iterator<String> iterator() {
        return Iterators.forArray((Object[])this.components);
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.path;
    }

    public static ModelPath path(String path) {
        return BY_PATH.get(path);
    }

    @VisibleForTesting
    static ModelPath path(Iterable<String> names) {
        String[] components = (String[])Iterables.toArray(names, String.class);
        String path = ModelPath.pathString(components);
        return ModelPath.path(path, components);
    }

    private static ModelPath path(String path, String[] names) {
        for (String name : names) {
            if (name.indexOf(46) < 0) continue;
            return new ModelPath(path, names);
        }
        return BY_PATH.get(path, names);
    }

    public static String pathString(String ... names) {
        if (names.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                builder.append(SEPARATOR);
            }
            builder.append(names[i]);
        }
        return builder.toString();
    }

    public ModelPath child(String child) {
        if (this.components.length == 0) {
            return ModelPath.path(child, new String[]{child});
        }
        String[] childComponents = new String[this.components.length + 1];
        System.arraycopy(this.components, 0, childComponents, 0, this.components.length);
        childComponents[this.components.length] = child;
        return ModelPath.path(this.path + SEPARATOR + child, childComponents);
    }

    public ModelPath getRootParent() {
        return this.components.length <= 1 ? null : ModelPath.path(this.components[0]);
    }

    @Nullable
    public ModelPath getParent() {
        return this.parent;
    }

    private ModelPath doGetParent() {
        if (this.components.length == 0) {
            return null;
        }
        if (this.components.length == 1) {
            return ROOT;
        }
        String[] parentComponents = new String[this.components.length - 1];
        System.arraycopy(this.components, 0, parentComponents, 0, this.components.length - 1);
        int parentPathLength = this.path.length() - this.components[this.components.length - 1].length() - 1;
        return ModelPath.path(this.path.substring(0, parentPathLength), parentComponents);
    }

    public String getName() {
        if (this.components.length == 0) {
            return "";
        }
        return this.components[this.components.length - 1];
    }

    public boolean isDirectChild(@Nullable ModelPath other) {
        if (other == null) {
            return false;
        }
        if (other.components.length != this.components.length + 1) {
            return false;
        }
        ModelPath otherParent = other.getParent();
        return otherParent != null && otherParent.equals(this);
    }

    public boolean isDescendant(@Nullable ModelPath other) {
        if (other == null) {
            return false;
        }
        int length = this.components.length;
        if (other.components.length <= this.components.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.components[i].equals(other.components[i])) continue;
            return false;
        }
        return true;
    }

    public ModelPath descendant(ModelPath path) {
        if (this.components.length == 0) {
            return path;
        }
        if (path.components.length == 0) {
            return this;
        }
        String[] descendantComponents = new String[this.components.length + path.components.length];
        System.arraycopy(this.components, 0, descendantComponents, 0, this.components.length);
        System.arraycopy(path.components, 0, descendantComponents, this.components.length, path.components.length);
        return ModelPath.path(this.path + SEPARATOR + path.getPath(), descendantComponents);
    }

    public static void validateName(String name) {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot use an empty string as a model element name.");
        }
        char firstChar = name.charAt(0);
        if (INVALID_FIRST_CHAR_MATCHER.matches(firstChar)) {
            throw new InvalidNameException(String.format("Model element name '%s' has illegal first character '%s' (names must start with an ASCII letter or underscore).", name, Character.valueOf(firstChar)));
        }
        for (int i = 1; i < name.length(); ++i) {
            char character = name.charAt(i);
            if (!INVALID_CHAR_MATCHER.matches(character)) continue;
            throw new InvalidNameException(String.format("Model element name '%s' contains illegal character '%s' (only ASCII letters, numbers and the underscore are allowed).", name, Character.valueOf(character)));
        }
    }

    @Nullable
    public static ModelPath validatedPath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        ModelPath.validatePath(path);
        return ModelPath.path(path);
    }

    public static ModelPath nonNullValidatedPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        return ModelPath.validatedPath(path);
    }

    public static void validatePath(String path) throws InvalidPathException {
        if (path.isEmpty()) {
            throw new InvalidPathException("Cannot use an empty string as a model path.", null);
        }
        if (path.startsWith(SEPARATOR)) {
            throw new InvalidPathException(String.format("Model path '%s' cannot start with name separator '%s'.", path, SEPARATOR), null);
        }
        if (path.endsWith(SEPARATOR)) {
            throw new InvalidPathException(String.format("Model path '%s' cannot end with name separator '%s'.", path, SEPARATOR), null);
        }
        String[] names = ModelPath.splitPath(path);
        if (names.length == 1) {
            ModelPath.validateName(names[0]);
        } else {
            for (String name : names) {
                try {
                    ModelPath.validateName(name);
                }
                catch (InvalidNameException e) {
                    throw new InvalidPathException(String.format("Model path '%s' is invalid due to invalid name component.", path), e);
                }
            }
        }
    }

    private static String[] splitPath(String path) {
        ArrayList components = Lists.newArrayListWithCapacity((int)path.length());
        StringTokenizer tokenizer = new StringTokenizer(path, SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String component = tokenizer.nextToken();
            if (component.isEmpty()) continue;
            components.add(component);
        }
        return components.toArray(new String[components.size()]);
    }

    private static class Cache {
        private final WeakHashMap<String, ModelPath> cache = new WeakHashMap();

        public Cache(ModelPath root) {
            this.cache.put(root.path, root);
        }

        public synchronized ModelPath get(String path) {
            ModelPath result = this.cache.get(path);
            if (result != null) {
                return result;
            }
            result = new ModelPath(path);
            this.cache.put(path, result);
            return result;
        }

        public synchronized ModelPath get(String path, String[] names) {
            ModelPath result = this.cache.get(path);
            if (result != null) {
                return result;
            }
            result = new ModelPath(path, names);
            this.cache.put(path, result);
            return result;
        }
    }

    @Contextual
    public static class InvalidPathException
    extends GradleException {
        public InvalidPathException(String message, InvalidNameException e) {
            super(message, (Throwable)((Object)e));
        }
    }

    public static class InvalidNameException
    extends GradleException {
        public InvalidNameException(String message) {
            super(message);
        }
    }
}

