/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.action;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.launcher.cli.action.ExecuteBuildAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildActionSerializer {
    public static Serializer<BuildAction> create() {
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(ExecuteBuildAction.class, (Serializer)new ExecuteBuildActionSerializer());
        registry.useJavaSerialization(BuildAction.class);
        return registry.build(BuildAction.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullableFileSerializer
    implements Serializer<File> {
        private NullableFileSerializer() {
        }

        public void write(Encoder encoder, File value) throws Exception {
            if (value == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                encoder.writeString((CharSequence)value.getPath());
            }
        }

        public File read(Decoder decoder) throws Exception {
            if (decoder.readBoolean()) {
                return new File(decoder.readString());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecuteBuildActionSerializer
    implements Serializer<ExecuteBuildAction> {
        private final Serializer<LogLevel> logLevelSerializer;
        private final Serializer<ShowStacktrace> showStacktraceSerializer;
        private final Serializer<ConsoleOutput> consoleOutputSerializer;
        private final Serializer<WarningMode> warningModeSerializer;
        private final Serializer<File> nullableFileSerializer = new NullableFileSerializer();
        private final Serializer<List<String>> stringListSerializer = new ListSerializer(BaseSerializerFactory.STRING_SERIALIZER);
        private final Serializer<List<File>> fileListSerializer = new ListSerializer(BaseSerializerFactory.FILE_SERIALIZER);
        private final Serializer<Set<String>> stringSetSerializer = new SetSerializer(BaseSerializerFactory.STRING_SERIALIZER);

        ExecuteBuildActionSerializer() {
            BaseSerializerFactory serializerFactory = new BaseSerializerFactory();
            this.logLevelSerializer = serializerFactory.getSerializerFor(LogLevel.class);
            this.showStacktraceSerializer = serializerFactory.getSerializerFor(ShowStacktrace.class);
            this.consoleOutputSerializer = serializerFactory.getSerializerFor(ConsoleOutput.class);
            this.warningModeSerializer = serializerFactory.getSerializerFor(WarningMode.class);
        }

        public void write(Encoder encoder, ExecuteBuildAction action) throws Exception {
            StartParameterInternal startParameter = action.getStartParameter();
            this.logLevelSerializer.write(encoder, (Object)startParameter.getLogLevel());
            this.showStacktraceSerializer.write(encoder, (Object)startParameter.getShowStacktrace());
            this.consoleOutputSerializer.write(encoder, (Object)startParameter.getConsoleOutput());
            this.warningModeSerializer.write(encoder, (Object)startParameter.getWarningMode());
            encoder.writeBoolean(startParameter.isParallelProjectExecutionEnabled());
            encoder.writeSmallInt(startParameter.getMaxWorkerCount());
            this.writeTaskRequests(encoder, startParameter.getTaskRequests());
            this.stringSetSerializer.write(encoder, (Object)startParameter.getExcludedTaskNames());
            this.nullableFileSerializer.write(encoder, (Object)startParameter.getBuildFile());
            this.nullableFileSerializer.write(encoder, (Object)startParameter.getProjectDir());
            this.nullableFileSerializer.write(encoder, (Object)startParameter.getSettingsFile());
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, (Object)startParameter.getCurrentDir());
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, (Object)startParameter.getGradleUserHomeDir());
            this.nullableFileSerializer.write(encoder, (Object)startParameter.getGradleHomeDir());
            this.nullableFileSerializer.write(encoder, (Object)startParameter.getProjectCacheDir());
            this.fileListSerializer.write(encoder, (Object)startParameter.getIncludedBuilds());
            encoder.writeBoolean(startParameter.isUseEmptySettings());
            encoder.writeBoolean(startParameter.isSearchUpwards());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, (Object)startParameter.getProjectProperties());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, (Object)startParameter.getSystemPropertiesArgs());
            this.fileListSerializer.write(encoder, (Object)startParameter.getInitScripts());
            this.stringListSerializer.write(encoder, (Object)startParameter.getLockedDependenciesToUpdate());
            encoder.writeBoolean(startParameter.isBuildProjectDependencies());
            encoder.writeBoolean(startParameter.isDryRun());
            encoder.writeBoolean(startParameter.isRerunTasks());
            encoder.writeBoolean(startParameter.isProfile());
            encoder.writeBoolean(startParameter.isContinueOnFailure());
            encoder.writeBoolean(startParameter.isOffline());
            encoder.writeBoolean(startParameter.isRefreshDependencies());
            encoder.writeBoolean(startParameter.isRecompileScripts());
            encoder.writeBoolean(startParameter.isBuildCacheEnabled());
            encoder.writeBoolean(startParameter.isBuildCacheDebugLogging());
            encoder.writeBoolean(startParameter.isConfigureOnDemand());
            encoder.writeBoolean(startParameter.isContinuous());
            encoder.writeBoolean(startParameter.isBuildScan());
            encoder.writeBoolean(startParameter.isNoBuildScan());
            encoder.writeBoolean(startParameter.isInteractive());
            encoder.writeBoolean(startParameter.isWriteDependencyLocks());
            this.stringSetSerializer.write(encoder, (Object)startParameter.getDeprecations());
        }

        private void writeTaskRequests(Encoder encoder, List<TaskExecutionRequest> taskRequests) throws Exception {
            encoder.writeSmallInt(taskRequests.size());
            for (TaskExecutionRequest taskRequest : taskRequests) {
                if (!(taskRequest instanceof DefaultTaskExecutionRequest)) {
                    throw new UnsupportedOperationException();
                }
                DefaultTaskExecutionRequest request = (DefaultTaskExecutionRequest)taskRequests.get(0);
                this.stringListSerializer.write(encoder, request.getArgs());
            }
        }

        public ExecuteBuildAction read(Decoder decoder) throws Exception {
            StartParameterInternal startParameter = new StartParameterInternal();
            startParameter.setLogLevel((LogLevel)this.logLevelSerializer.read(decoder));
            startParameter.setShowStacktrace((ShowStacktrace)this.showStacktraceSerializer.read(decoder));
            startParameter.setConsoleOutput((ConsoleOutput)this.consoleOutputSerializer.read(decoder));
            startParameter.setWarningMode((WarningMode)this.warningModeSerializer.read(decoder));
            startParameter.setParallelProjectExecutionEnabled(decoder.readBoolean());
            startParameter.setMaxWorkerCount(decoder.readSmallInt());
            startParameter.setTaskRequests(this.readTaskRequests(decoder));
            startParameter.setExcludedTaskNames((Iterable)this.stringSetSerializer.read(decoder));
            startParameter.setBuildFile((File)this.nullableFileSerializer.read(decoder));
            startParameter.setProjectDir((File)this.nullableFileSerializer.read(decoder));
            startParameter.setSettingsFile((File)this.nullableFileSerializer.read(decoder));
            startParameter.setCurrentDir((File)BaseSerializerFactory.FILE_SERIALIZER.read(decoder));
            startParameter.setGradleUserHomeDir((File)BaseSerializerFactory.FILE_SERIALIZER.read(decoder));
            startParameter.setGradleHomeDir((File)this.nullableFileSerializer.read(decoder));
            startParameter.setProjectCacheDir((File)this.nullableFileSerializer.read(decoder));
            startParameter.setIncludedBuilds((List)this.fileListSerializer.read(decoder));
            if (decoder.readBoolean()) {
                startParameter.useEmptySettings();
            }
            startParameter.setSearchUpwards(decoder.readBoolean());
            startParameter.setProjectProperties((Map)BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder));
            startParameter.setSystemPropertiesArgs((Map)BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder));
            startParameter.setInitScripts((List)this.fileListSerializer.read(decoder));
            startParameter.setLockedDependenciesToUpdate((List)this.stringListSerializer.read(decoder));
            startParameter.setBuildProjectDependencies(decoder.readBoolean());
            startParameter.setDryRun(decoder.readBoolean());
            startParameter.setRerunTasks(decoder.readBoolean());
            startParameter.setProfile(decoder.readBoolean());
            startParameter.setContinueOnFailure(decoder.readBoolean());
            startParameter.setOffline(decoder.readBoolean());
            startParameter.setRefreshDependencies(decoder.readBoolean());
            startParameter.setRecompileScripts(decoder.readBoolean());
            startParameter.setBuildCacheEnabled(decoder.readBoolean());
            startParameter.setBuildCacheDebugLogging(decoder.readBoolean());
            startParameter.setConfigureOnDemand(decoder.readBoolean());
            startParameter.setContinuous(decoder.readBoolean());
            startParameter.setBuildScan(decoder.readBoolean());
            startParameter.setNoBuildScan(decoder.readBoolean());
            startParameter.setInteractive(decoder.readBoolean());
            startParameter.setWriteDependencyLocks(decoder.readBoolean());
            for (String warning : (Set)this.stringSetSerializer.read(decoder)) {
                startParameter.addDeprecation(warning);
            }
            return new ExecuteBuildAction(startParameter);
        }

        private List<TaskExecutionRequest> readTaskRequests(Decoder decoder) throws Exception {
            int requestCount = decoder.readSmallInt();
            ArrayList<TaskExecutionRequest> taskExecutionRequests = new ArrayList<TaskExecutionRequest>(requestCount);
            for (int i = 0; i < requestCount; ++i) {
                taskExecutionRequests.add(new DefaultTaskExecutionRequest((Iterable)this.stringListSerializer.read(decoder)));
            }
            return taskExecutionRequests;
        }
    }
}

