/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.announce.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.gradle.api.plugins.announce.Announcer;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Twitter
implements Announcer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String username;
    private final String password;

    public Twitter(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void send(String title, String message) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL("https://twitter.com/statuses/update.xml").openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            String credentials = Base64.encodeBase64String((byte[])(this.username + ":" + this.password).getBytes("UTF-8")).trim();
            connection.setRequestProperty("Authorization", "Basic " + credentials);
            OutputStream outputStream = connection.getOutputStream();
            IOUtils.write((String)("status=" + URLEncoder.encode(message, "UTF-8")), (OutputStream)outputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            this.logger.info("Successfully tweeted '" + message + "' using account '" + this.username + "'");
            if (this.logger.isDebugEnabled()) {
                InputStream inputStream = connection.getInputStream();
                this.logger.debug(IOUtils.toString((InputStream)inputStream, (String)"UTF-8"));
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

