/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public final class CompareToTranslator
extends AbstractTranslator {
    @NotNull
    private final KtBinaryExpression expression;

    public static boolean isCompareToCall(@NotNull KtToken operationToken, @Nullable CallableDescriptor operationDescriptor) {
        if (!OperatorConventions.COMPARISON_OPERATIONS.contains(operationToken) || operationDescriptor == null) {
            return false;
        }
        return JsDescriptorUtils.isCompareTo(operationDescriptor);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        return new CompareToTranslator(expression2, context).translate();
    }

    private CompareToTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression2;
        CallableDescriptor descriptor2 = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression2);
        assert (descriptor2 != null) : "CompareTo should always have a descriptor";
        assert (OperatorConventions.COMPARISON_OPERATIONS.contains(PsiUtils.getOperationToken(expression2))) : ErrorReportingUtils.message(expression2, "CompareToTranslator supported only expressions with operation token from COMPARISON_OPERATIONS, expression: " + expression2.getText());
    }

    @NotNull
    private JsExpression translate() {
        JsBinaryOperator correspondingOperator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(this.expression));
        JsExpression methodCall = BinaryOperationTranslator.translateAsOverloadedCall(this.expression, this.context());
        return new JsBinaryOperation(correspondingOperator, methodCall, new JsIntLiteral(0));
    }
}

