/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Map;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.MetadataProvider;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataAdapter;
import org.gradle.internal.component.external.model.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;

class CachedMetadataProvider
implements MetadataProvider {
    private final BuildableModuleComponentMetaDataResolveResult cachedResult;
    private final ComponentMetadata cachedComponentMetadata;
    private final boolean usable;

    CachedMetadataProvider(BuildableModuleComponentMetaDataResolveResult result) {
        this.cachedResult = result;
        this.usable = this.cachedResult.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved;
        this.cachedComponentMetadata = this.usable ? new ComponentMetadataAdapter(this.cachedResult.getMetaData()) : null;
    }

    @Override
    public ComponentMetadata getComponentMetadata() {
        return this.cachedComponentMetadata;
    }

    @Override
    public IvyModuleDescriptor getIvyModuleDescriptor() {
        ModuleComponentResolveMetadata metaData = this.cachedResult.getMetaData();
        if (metaData instanceof IvyModuleResolveMetadata) {
            IvyModuleResolveMetadata ivyMetadata = (IvyModuleResolveMetadata)metaData;
            return new DefaultIvyModuleDescriptor((Map<NamespaceId, String>)ivyMetadata.getExtraAttributes(), ivyMetadata.getBranch(), ivyMetadata.getStatus());
        }
        return null;
    }

    @Override
    public boolean isUsable() {
        return this.usable;
    }
}

