/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.util.GUtil;

public class ProgressLogEventGenerator
implements OutputEventListener {
    private static final String EOL = SystemProperties.getInstance().getLineSeparator();
    private final OutputEventListener listener;
    private final Map<OperationIdentifier, Operation> operations = new LinkedHashMap<OperationIdentifier, Operation>();

    public ProgressLogEventGenerator(OutputEventListener listener) {
        this.listener = listener;
    }

    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            this.onStart((ProgressStartEvent)event);
        } else if (event instanceof ProgressCompleteEvent) {
            this.onComplete((ProgressCompleteEvent)event);
        } else if (event instanceof RenderableOutputEvent) {
            this.doOutput((RenderableOutputEvent)event);
        } else if (!(event instanceof ProgressEvent)) {
            this.listener.onOutput(event);
        }
    }

    private void doOutput(RenderableOutputEvent event) {
        for (Operation operation : this.operations.values()) {
            operation.completeHeader();
        }
        this.listener.onOutput(event);
    }

    private void onComplete(ProgressCompleteEvent progressCompleteEvent) {
        assert (!this.operations.isEmpty());
        Operation operation = this.operations.remove(progressCompleteEvent.getProgressOperationId());
        this.completeOperation(progressCompleteEvent, operation);
    }

    private void completeOperation(ProgressCompleteEvent progressCompleteEvent, Operation operation) {
        operation.status = progressCompleteEvent.getStatus();
        operation.completeTime = progressCompleteEvent.getTimestamp();
        operation.complete();
    }

    private void onStart(ProgressStartEvent progressStartEvent) {
        Operation operation = new Operation(progressStartEvent.getCategory(), progressStartEvent.getLoggingHeader(), progressStartEvent.getTimestamp(), progressStartEvent.getBuildOperationId());
        this.operations.put(progressStartEvent.getProgressOperationId(), operation);
    }

    private class Operation {
        private final OperationIdentifier buildOperationIdentifier;
        private final String category;
        private final String loggingHeader;
        private final long startTime;
        private final boolean hasLoggingHeader;
        private String status = "";
        private State state = State.None;
        private long completeTime;

        private Operation(String category, String loggingHeader, long startTime, OperationIdentifier buildOperationIdentifier) {
            this.category = category;
            this.loggingHeader = loggingHeader;
            this.startTime = startTime;
            this.hasLoggingHeader = GUtil.isTrue((Object)loggingHeader);
            this.buildOperationIdentifier = buildOperationIdentifier;
        }

        private StyledTextOutputEvent plainTextEvent(long timestamp, String text) {
            return new StyledTextOutputEvent(timestamp, this.category, LogLevel.LIFECYCLE, this.buildOperationIdentifier, Collections.singletonList(new StyledTextOutputEvent.Span(text)));
        }

        private StyledTextOutputEvent styledTextEvent(long timestamp, StyledTextOutputEvent.Span ... spans) {
            return new StyledTextOutputEvent(timestamp, this.category, LogLevel.LIFECYCLE, this.buildOperationIdentifier, Arrays.asList(spans));
        }

        private void doOutput(RenderableOutputEvent event) {
            Operation pending;
            Iterator i$ = ProgressLogEventGenerator.this.operations.values().iterator();
            while (i$.hasNext() && (pending = (Operation)i$.next()) != this) {
                pending.completeHeader();
            }
            ProgressLogEventGenerator.this.listener.onOutput(event);
        }

        public void startHeader() {
            assert (this.state == State.None);
            if (this.hasLoggingHeader) {
                this.state = State.HeaderStarted;
                this.doOutput(this.plainTextEvent(this.startTime, this.loggingHeader));
            } else {
                this.state = State.HeaderCompleted;
            }
        }

        public void completeHeader() {
            switch (this.state) {
                case None: {
                    if (!this.hasLoggingHeader) break;
                    ProgressLogEventGenerator.this.listener.onOutput(this.plainTextEvent(this.startTime, this.loggingHeader + EOL));
                    break;
                }
                case HeaderStarted: {
                    ProgressLogEventGenerator.this.listener.onOutput(this.plainTextEvent(this.startTime, EOL));
                    break;
                }
                case HeaderCompleted: {
                    return;
                }
                default: {
                    throw new IllegalStateException("state is " + (Object)((Object)this.state));
                }
            }
            this.state = State.HeaderCompleted;
        }

        public void complete() {
            boolean hasStatus = GUtil.isTrue((Object)this.status);
            switch (this.state) {
                case None: {
                    if (this.hasLoggingHeader && hasStatus) {
                        this.doOutput(this.styledTextEvent(this.completeTime, new StyledTextOutputEvent.Span(this.loggingHeader + ' '), new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                        break;
                    }
                    if (!this.hasLoggingHeader) break;
                    this.doOutput(this.plainTextEvent(this.completeTime, this.loggingHeader + EOL));
                    break;
                }
                case HeaderStarted: {
                    assert (this.hasLoggingHeader);
                    if (hasStatus) {
                        this.doOutput(this.styledTextEvent(this.completeTime, new StyledTextOutputEvent.Span(" "), new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                        break;
                    }
                    this.doOutput(this.plainTextEvent(this.completeTime, EOL));
                    break;
                }
                case HeaderCompleted: {
                    if (!this.hasLoggingHeader || !hasStatus) break;
                    this.doOutput(this.styledTextEvent(this.completeTime, new StyledTextOutputEvent.Span(this.loggingHeader + ' '), new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                    break;
                }
                default: {
                    throw new IllegalStateException("state is " + (Object)((Object)this.state));
                }
            }
            this.state = State.Completed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        None,
        HeaderStarted,
        HeaderCompleted,
        Completed;

    }
}

