/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.BuildDependenciesOnlyFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeFileCollection
extends AbstractFileCollection
implements FileCollectionContainer,
TaskDependencyContainer {
    public Set<File> getFiles() {
        return CompositeFileCollection.getFiles(this.getSourceCollections());
    }

    @Override
    public Iterator<File> iterator() {
        List<? extends FileCollectionInternal> sourceCollections = this.getSourceCollections();
        switch (sourceCollections.size()) {
            case 0: {
                return Iterators.emptyIterator();
            }
            case 1: {
                return sourceCollections.get(0).iterator();
            }
        }
        return CompositeFileCollection.getFiles(sourceCollections).iterator();
    }

    private static Set<File> getFiles(List<? extends FileCollectionInternal> sourceCollections) {
        switch (sourceCollections.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return sourceCollections.get(0).getFiles();
            }
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (FileCollection fileCollection : sourceCollections) {
            builder.addAll((Iterable)fileCollection);
        }
        return builder.build();
    }

    @Override
    public boolean contains(File file) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (!fileCollection.contains(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            if (fileCollection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void addAsResourceCollection(Object builder, String nodeName) {
        for (FileCollection fileCollection : this.getSourceCollections()) {
            fileCollection.addToAntBuilder(builder, nodeName, FileCollection.AntType.ResourceCollection);
        }
    }

    @Override
    protected Collection<DirectoryFileTree> getAsFileTrees() {
        ArrayList<DirectoryFileTree> fileTree = new ArrayList<DirectoryFileTree>();
        for (FileCollection fileCollection : this.getSourceCollections()) {
            AbstractFileCollection collection = (AbstractFileCollection)fileCollection;
            fileTree.addAll(collection.getAsFileTrees());
        }
        return fileTree;
    }

    @Override
    public FileTree getAsFileTree() {
        return new CompositeFileTree(){

            public void visitContents(FileCollectionResolveContext context) {
                ResolvableFileCollectionResolveContext nested = context.newContext();
                CompositeFileCollection.this.visitContents(nested);
                context.add(nested.resolveAsFileTrees());
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                CompositeFileCollection.this.visitDependencies(context);
            }

            public String getDisplayName() {
                return CompositeFileCollection.this.getDisplayName();
            }
        };
    }

    @Override
    public FileCollection filter(final Spec<? super File> filterSpec) {
        return new CompositeFileCollection(){

            public void visitContents(FileCollectionResolveContext context) {
                for (FileCollection fileCollection : CompositeFileCollection.this.getSourceCollections()) {
                    context.add(fileCollection.filter(filterSpec));
                }
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                CompositeFileCollection.this.visitDependencies(context);
            }

            public String getDisplayName() {
                return CompositeFileCollection.this.getDisplayName();
            }
        };
    }

    @Override
    public final TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            public String toString() {
                return CompositeFileCollection.this.toString() + " dependencies";
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                CompositeFileCollection.this.visitDependencies(context);
            }
        };
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        BuildDependenciesOnlyFileCollectionResolveContext fileContext = new BuildDependenciesOnlyFileCollectionResolveContext(context);
        this.visitContents(fileContext);
    }

    protected List<? extends FileCollectionInternal> getSourceCollections() {
        DefaultFileCollectionResolveContext context = new DefaultFileCollectionResolveContext(new IdentityFileResolver());
        this.visitContents(context);
        return context.resolveAsFileCollections();
    }

    @Override
    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        for (FileCollectionInternal fileCollectionInternal : this.getSourceCollections()) {
            fileCollectionInternal.registerWatchPoints(builder);
        }
    }

    @Override
    public void visitRootElements(FileCollectionVisitor visitor) {
        for (FileCollectionInternal fileCollectionInternal : this.getSourceCollections()) {
            fileCollectionInternal.visitRootElements(visitor);
        }
    }
}

