/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.DefaultBuildRequestContext;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;
import org.gradle.launcher.daemon.server.exec.DaemonConnectionBackedEventConsumer;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;

public class ExecuteBuild
extends BuildCommandOnly {
    private static final Logger LOGGER = Logging.getLogger(ExecuteBuild.class);
    private final BuildActionExecuter<BuildActionParameters> actionExecuter;
    private final DaemonRunningStats runningStats;
    private final ServiceRegistry contextServices;

    public ExecuteBuild(BuildActionExecuter<BuildActionParameters> actionExecuter, DaemonRunningStats runningStats, ServiceRegistry contextServices) {
        this.actionExecuter = actionExecuter;
        this.runningStats = runningStats;
        this.contextServices = contextServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBuild(DaemonCommandExecution execution, Build build) {
        LOGGER.debug("The daemon has started executing the build.");
        LOGGER.debug("Executing build with daemon context: {}", (Object)execution.getDaemonContext());
        this.runningStats.buildStarted();
        DaemonConnectionBackedEventConsumer buildEventConsumer = new DaemonConnectionBackedEventConsumer(execution);
        try {
            BuildCancellationToken cancellationToken = execution.getDaemonStateControl().getCancellationToken();
            DefaultBuildRequestContext buildRequestContext = new DefaultBuildRequestContext(build.getBuildRequestMetaData(), cancellationToken, (BuildEventConsumer)buildEventConsumer);
            if (!build.getParameters().isContinuous()) {
                buildRequestContext.getCancellationToken().addCallback(new Runnable(){

                    @Override
                    public void run() {
                        LOGGER.info("The daemon has received a build cancellation request.");
                    }
                });
            }
            Object result = this.actionExecuter.execute(build.getAction(), (BuildRequestContext)buildRequestContext, build.getParameters(), this.contextServices);
            execution.setResult(result);
        }
        catch (ReportedException e) {
            execution.setException(e);
        }
        finally {
            buildEventConsumer.waitForFinish();
            this.runningStats.buildFinished();
            LOGGER.debug("The daemon has finished executing the build.");
        }
        execution.proceed();
    }
}

